/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.ObjectName;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgent;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.resources.impl.OsgiUtils;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDistributionAgentFactory<DistributionAgentMBeanType> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String NAME = "name";
    private static final String ENABLED = "enabled";
    static final String DEFAULT_TRIGGER_TARGET = "(name=)";
    private static final String TRIGGERS_TARGET = "triggers.target";
    static final String LOG_LEVEL = "log.level";
    private final Class<DistributionAgentMBeanType> distributionAgentMBeanType;
    private ServiceRegistration<DistributionAgent> componentReg;
    private ServiceRegistration<DistributionAgentMBeanType> mbeanServiceRegistration;
    private String agentName;
    private final List<DistributionTrigger> triggers = new CopyOnWriteArrayList<DistributionTrigger>();
    private boolean triggersEnabled = false;
    private SimpleDistributionAgent agent;

    AbstractDistributionAgentFactory(Class<DistributionAgentMBeanType> distributionAgentMBeanType) {
        this.distributionAgentMBeanType = distributionAgentMBeanType;
    }

    void activate(BundleContext context, Map<String, Object> config) {
        this.log.info("activating with config {}", (Object)OsgiUtils.osgiPropertyMapToString(config));
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        boolean enabled = PropertiesUtil.toBoolean((Object)config.get(ENABLED), (boolean)true);
        String triggersTarget = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(TRIGGERS_TARGET), null));
        this.triggersEnabled = triggersTarget != null && triggersTarget.trim().length() > 0;
        this.agentName = PropertiesUtil.toString((Object)config.get(NAME), null);
        if (enabled && this.agentName != null) {
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                if (entry.getKey().startsWith("service.") || entry.getKey().startsWith("component.")) continue;
                ((Dictionary)props).put(entry.getKey(), entry.getValue());
            }
            if (this.componentReg == null) {
                DefaultDistributionLog distributionLog = null;
                try {
                    String logLevel = PropertiesUtil.toString((Object)config.get(LOG_LEVEL), (String)DefaultDistributionLog.LogLevel.INFO.name());
                    DefaultDistributionLog.LogLevel level = DefaultDistributionLog.LogLevel.valueOf(logLevel.trim().toUpperCase());
                    if (level == null) {
                        level = DefaultDistributionLog.LogLevel.INFO;
                    }
                    distributionLog = new DefaultDistributionLog(DistributionComponentKind.AGENT, this.agentName, SimpleDistributionAgent.class, level);
                    this.agent = this.createAgent(this.agentName, context, config, distributionLog);
                }
                catch (Throwable t) {
                    if (distributionLog != null) {
                        distributionLog.error("Cannot create agent", t);
                    }
                    this.log.error("Cannot create agent {}", (Object)OsgiUtils.osgiPropertyMapToString(config), (Object)t);
                }
                if (this.agent != null) {
                    this.componentReg = context.registerService(DistributionAgent.class, (Object)this.agent, props);
                    this.agent.enable();
                    if (this.triggersEnabled) {
                        for (DistributionTrigger trigger : this.triggers) {
                            this.agent.enableTrigger(trigger);
                        }
                    }
                    Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                    ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling.distribution:type=agent,id=" + ObjectName.quote(this.agentName));
                    DistributionAgentMBeanType mbean = this.createMBeanAgent(this.agent, config);
                    this.mbeanServiceRegistration = context.registerService(this.distributionAgentMBeanType, mbean, mbeanProps);
                }
                this.log.info("activated agent {}", (Object)this.agentName);
            }
        }
    }

    synchronized void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        this.triggers.add(distributionTrigger);
        if (this.agent != null && this.triggersEnabled) {
            this.agent.enableTrigger(distributionTrigger);
        }
    }

    synchronized void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        this.triggers.remove(distributionTrigger);
        if (this.agent != null) {
            this.agent.disableTrigger(distributionTrigger);
        }
    }

    void deactivate(BundleContext context) {
        if (this.componentReg != null) {
            ServiceReference reference = this.componentReg.getReference();
            Object service = context.getService(reference);
            if (service instanceof SimpleDistributionAgent) {
                SimpleDistributionAgent agent = (SimpleDistributionAgent)service;
                for (DistributionTrigger trigger : this.triggers) {
                    agent.disableTrigger(trigger);
                }
                this.triggers.clear();
                this.triggersEnabled = false;
                agent.disable();
            }
            if (AbstractDistributionAgentFactory.safeUnregister(this.componentReg)) {
                this.componentReg = null;
            }
            this.agent = null;
        }
        if (AbstractDistributionAgentFactory.safeUnregister(this.mbeanServiceRegistration)) {
            this.mbeanServiceRegistration = null;
        }
        this.log.info("deactivated agent {}", (Object)this.agentName);
    }

    private static boolean safeUnregister(ServiceRegistration<?> serviceRegistration) {
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            return true;
        }
        return false;
    }

    protected abstract SimpleDistributionAgent createAgent(String var1, BundleContext var2, Map<String, Object> var3, DefaultDistributionLog var4);

    protected abstract DistributionAgentMBeanType createMBeanAgent(DistributionAgent var1, Map<String, Object> var2);
}

