/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.precondition;

import java.io.Closeable;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.impl.precondition.PackageStatusWatcher;
import org.apache.sling.distribution.journal.impl.precondition.Precondition;
import org.apache.sling.distribution.journal.messages.PackageStatusMessage;
import org.apache.sling.distribution.journal.shared.Topics;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"name=staging", "scheduler.concurrent:Boolean=false", "scheduler.period:Long=86400"})
public class StagingPrecondition
implements Precondition,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StagingPrecondition.class);
    @Reference
    private MessagingProvider messagingProvider;
    @Reference
    private Topics topics;
    private volatile PackageStatusWatcher watcher;

    @Activate
    public void activate() {
        this.watcher = new PackageStatusWatcher(this.messagingProvider, this.topics);
        LOG.info("Activated Staging Precondition");
    }

    @Deactivate
    public synchronized void deactivate() {
        IOUtils.closeQuietly((Closeable)this.watcher);
    }

    @Override
    public Precondition.Decision canProcess(String subAgentName, long pkgOffset) {
        PackageStatusMessage.Status status = this.getStatus(subAgentName, pkgOffset);
        if (status == null) {
            return Precondition.Decision.WAIT;
        }
        return status == PackageStatusMessage.Status.IMPORTED ? Precondition.Decision.ACCEPT : Precondition.Decision.SKIP;
    }

    private synchronized PackageStatusMessage.Status getStatus(String subAgentName, long pkgOffset) {
        return this.watcher.getStatus(subAgentName, pkgOffset);
    }

    @Override
    public synchronized void run() {
        LOG.info("Purging StagingPrecondition cache");
        IOUtils.closeQuietly((Closeable)this.watcher);
        this.watcher = new PackageStatusWatcher(this.messagingProvider, this.topics);
    }
}

