/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRegexEntryHandler
implements EntryHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Pattern pattern;

    AbstractRegexEntryHandler(@NotNull String regex) {
        this(Pattern.compile(regex));
    }

    AbstractRegexEntryHandler(@NotNull Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public final boolean matches(@NotNull String path) {
        return this.pattern.matcher(path).matches();
    }

    @NotNull
    protected final Pattern getPattern() {
        return this.pattern;
    }

    protected String extractTargetRunMode(String path, ContentPackage2FeatureModelConverter converter, String runMode, String runModeMatch) {
        String targetRunmode;
        if (ContentPackage2FeatureModelConverter.RunModePolicy.PREPEND_INHERITED.equals((Object)converter.getRunModePolicy())) {
            ArrayList runModes = new ArrayList();
            List inheritedRunModes = runMode == null ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)runMode, (char)'.'));
            runModes.addAll(inheritedRunModes);
            if (StringUtils.isNotEmpty((CharSequence)runModeMatch)) {
                this.logger.debug("Runmode {} was extracted from path {}", (Object)runModeMatch, (Object)path);
                List<String> newRunModes = Arrays.asList(StringUtils.split((String)runModeMatch, (char)'.'));
                List newRunModesList = newRunModes.stream().filter(mode -> !runModes.contains(mode)).collect(Collectors.toList());
                if (!runModes.isEmpty() && !CollectionUtils.isEqualCollection(newRunModes, inheritedRunModes)) {
                    this.logger.info("Found diverging run modes list {} diverging from defined run modes on the parent {}", newRunModes, inheritedRunModes);
                    this.logger.info("Effective run modes: {}", runModes);
                }
                runModes.addAll(newRunModesList);
            }
            targetRunmode = String.join((CharSequence)".", runModes);
        } else {
            targetRunmode = runModeMatch;
        }
        return targetRunmode;
    }
}

