/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.DependencyUtil;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.jetbrains.annotations.NotNull;

public final class DefaultPackagesEventsEmitter
implements PackagesEventsEmitter {
    private static final String FILENAME = "content-packages.csv";
    private static final String PATH_SEPARATOR_CHAR = "!";
    private static final String PACKAGE_TYPE = "PACKAGE_TYPE";
    private final Stack<String> paths = new Stack();
    private final Stack<PackageId> hierarchy = new Stack();
    private final Collection<VaultPackage> dependenciesOnly = new LinkedList<VaultPackage>();
    private final Map<PackageId, String> idOutputLine = new HashMap<PackageId, String>();
    private final PrintWriter writer;
    private VaultPackage current;

    @NotNull
    public static DefaultPackagesEventsEmitter open(@NotNull File featureModelsOutputDirectory) throws IOException {
        if (!featureModelsOutputDirectory.exists()) {
            featureModelsOutputDirectory.mkdirs();
        }
        File contentPackagesFiles = new File(featureModelsOutputDirectory, FILENAME);
        return new DefaultPackagesEventsEmitter(new FileWriter(contentPackagesFiles));
    }

    protected DefaultPackagesEventsEmitter(@NotNull Writer writer) {
        this.writer = new PrintWriter(writer, true);
    }

    @Override
    public void start() {
        this.writer.printf("# File created on %s by the Apache Sling Content Package to Sling Feature converter\n", new Date()).printf("# content-package path, content-package ID, content-package type, content-package parent ID, path in parent content-package, absolute path\n", new Object[0]);
    }

    @Override
    public void end() {
        try {
            DependencyUtil.sort(this.dependenciesOnly);
            for (VaultPackage pkg : this.dependenciesOnly) {
                this.writer.printf(this.idOutputLine.get(pkg.getId()), new Object[0]);
            }
        }
        catch (CyclicDependencyException e) {
            throw new ArithmeticException("Cyclic dependencies between packages detected, cannot complete operation. " + (Object)((Object)e));
        }
        finally {
            this.writer.close();
            this.paths.clear();
            this.hierarchy.clear();
        }
    }

    @Override
    public void startPackage(@NotNull VaultPackage originalPackage) {
        PackageId id = originalPackage.getId();
        Dependency[] dependencies = originalPackage.getDependencies();
        this.paths.add(originalPackage.getFile().getAbsolutePath());
        this.hierarchy.add(id);
        this.current = originalPackage;
        this.dependenciesOnly.add(DefaultPackagesEventsEmitter.getDepOnlyPackage(id, dependencies));
        this.idOutputLine.put(id, String.format("%s,%s,%s,,,\n", this.paths.peek(), this.hierarchy.peek(), PACKAGE_TYPE));
    }

    @Override
    public void endPackage(@NotNull PackageId originalPackageId, @NotNull VaultPackage convertedPackage) {
        this.idOutputLine.computeIfPresent(originalPackageId, (key, value) -> value.replace(PACKAGE_TYPE, VaultPackageUtils.detectPackageType(convertedPackage).toString()));
        this.paths.pop();
        this.hierarchy.pop();
    }

    @Override
    public void startSubPackage(@NotNull String path, @NotNull VaultPackage originalPackage) {
        Dependency[] dependencies = originalPackage.getDependencies();
        this.paths.add(path);
        String absolutePath = this.paths.stream().collect(Collectors.joining(PATH_SEPARATOR_CHAR));
        PackageId id = originalPackage.getId();
        this.dependenciesOnly.add(DefaultPackagesEventsEmitter.getDepOnlyPackage(id, dependencies));
        this.idOutputLine.put(id, String.format("%s,%s,%s,%s,%s,%s\n", this.current.getFile().getAbsolutePath(), id, PACKAGE_TYPE, this.hierarchy.peek(), path, absolutePath));
        this.hierarchy.add(id);
    }

    @Override
    public void endSubPackage(@NotNull String path, @NotNull PackageId originalPackageId, @NotNull VaultPackage convertedPackage) {
        this.endPackage(originalPackageId, convertedPackage);
    }

    @NotNull
    static VaultPackage getDepOnlyPackage(final @NotNull PackageId id, final @NotNull Dependency[] dependencies) {
        return new VaultPackage(){

            public PackageId getId() {
                return id;
            }

            public Dependency[] getDependencies() {
                return dependencies;
            }

            public boolean requiresRoot() {
                return false;
            }

            public SubPackageHandling getSubPackageHandling() {
                return null;
            }

            public String getProperty(String name) {
                return null;
            }

            public PackageType getPackageType() {
                return null;
            }

            public String getLastWrappedBy() {
                return null;
            }

            public Calendar getLastWrapped() {
                return null;
            }

            public String getLastModifiedBy() {
                return null;
            }

            public Calendar getLastModified() {
                return null;
            }

            public String getDescription() {
                return null;
            }

            public Calendar getDateProperty(String name) {
                return null;
            }

            public String getCreatedBy() {
                return null;
            }

            public Calendar getCreated() {
                return null;
            }

            public AccessControlHandling getACHandling() {
                return null;
            }

            public boolean isValid() {
                return false;
            }

            public boolean isClosed() {
                return false;
            }

            public long getSize() {
                return 0L;
            }

            public PackageProperties getProperties() {
                return null;
            }

            public MetaInf getMetaInf() {
                return null;
            }

            public File getFile() {
                return null;
            }

            public Archive getArchive() {
                return null;
            }

            public void extract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
            }

            public void close() {
            }

            public boolean requiresRestart() {
                return false;
            }

            public Map<String, String> getExternalHooks() {
                return null;
            }

            @NotNull
            public Map<PackageId, URI> getDependenciesLocations() {
                return Collections.emptyMap();
            }

            public long getBuildCount() {
                return 0L;
            }
        };
    }
}

