/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordDeserializer;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.PrivilegeRecord;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.query.AbstractQueryHandler;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.AggregateRule;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheck;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheckError;
import org.apache.jackrabbit.core.query.lucene.DefaultHTMLExcerpt;
import org.apache.jackrabbit.core.query.lucene.DefaultRedoLogFactory;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.FileBasedNamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationEntityResolver;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexReader;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.LowerCaseSortComparator;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.NSRegistryBasedNamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NodeIndexer;
import org.apache.jackrabbit.core.query.lucene.NormalizeSortComparator;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.core.query.lucene.PropertyMetaData;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.RedoLogFactory;
import org.apache.jackrabbit.core.query.lucene.SharedFieldComparatorSource;
import org.apache.jackrabbit.core.query.lucene.SingletonTokenStream;
import org.apache.jackrabbit.core.query.lucene.SpellChecker;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.UpperCaseSortComparator;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.jackrabbit.core.query.lucene.directory.FSDirectoryManager;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.DefaultQueryNodeFactory;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.fork.ForkParser;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SearchIndex
extends AbstractQueryHandler {
    public static final Collection<Name> VALID_SYSTEM_INDEX_NODE_TYPE_NAMES = Collections.unmodifiableCollection(Arrays.asList(NameConstants.NT_CHILDNODEDEFINITION, NameConstants.NT_FROZENNODE, NameConstants.NT_NODETYPE, NameConstants.NT_PROPERTYDEFINITION, NameConstants.NT_VERSION, NameConstants.NT_VERSIONEDCHILD, NameConstants.NT_VERSIONHISTORY, NameConstants.NT_VERSIONLABELS, NameConstants.REP_NODETYPES, NameConstants.REP_SYSTEM, NameConstants.REP_VERSIONSTORAGE, NameConstants.NT_BASE, NameConstants.MIX_REFERENCEABLE));
    private static final DefaultQueryNodeFactory DEFAULT_QUERY_NODE_FACTORY = new DefaultQueryNodeFactory(VALID_SYSTEM_INDEX_NODE_TYPE_NAMES);
    private static final Logger log = LoggerFactory.getLogger(SearchIndex.class);
    private static final String NS_MAPPING_FILE = "ns_mappings.properties";
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_EXTRACTOR_POOL_SIZE = 0;
    public static final int DEFAULT_EXTRACTOR_BACK_LOG = Integer.MAX_VALUE;
    public static final long DEFAULT_EXTRACTOR_TIMEOUT = 100L;
    public static final int DEFAULT_TERM_INFOS_INDEX_DIVISOR = 1;
    protected static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();
    protected static final Path ROOT_PATH = PATH_FACTORY.create(NameConstants.ROOT);
    protected static final Path JCR_SYSTEM_PATH;
    protected MultiIndex index;
    private final JackrabbitAnalyzer analyzer = new JackrabbitAnalyzer();
    private String tikaConfigPath = null;
    private String forkJavaCommand = null;
    private Parser parser = null;
    private NamespaceMappings nsMappings;
    private String path;
    private int minMergeDocs = 100;
    private long maxVolatileIndexSize = 0x100000L;
    private int volatileIdleTime = 3;
    private long maxHistoryAge = 0L;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private int maxExtractLength = -10;
    private int extractorPoolSize = 2 * Runtime.getRuntime().availableProcessors();
    private int extractorBackLog = Integer.MAX_VALUE;
    private long extractorTimeout = 100L;
    private int bufferSize = 10;
    private boolean useCompoundFile = true;
    private boolean documentOrder = false;
    private boolean forceConsistencyCheck = false;
    private boolean consistencyCheckEnabled = false;
    private boolean autoRepair = true;
    private int cacheSize = 1000;
    private int resultFetchSize = Integer.MAX_VALUE;
    private boolean supportHighlighting = false;
    private boolean sizeEstimate = false;
    private Class<?> excerptProviderClass = DefaultHTMLExcerpt.class;
    private String indexingConfigPath;
    private Element indexingConfiguration;
    private IndexingConfiguration indexingConfig;
    private Class<?> indexingConfigurationClass = IndexingConfigurationImpl.class;
    private Class<?> synonymProviderClass;
    private SynonymProvider synProvider;
    private String synonymProviderConfigPath;
    private FileSystem synonymProviderConfigFs;
    private IndexFormatVersion indexFormatVersion;
    private Class<?> spellCheckerClass;
    private SpellChecker spellChecker;
    private Similarity similarity = Similarity.getDefault();
    private String directoryManagerClass = FSDirectoryManager.class.getName();
    private DirectoryManager directoryManager;
    private boolean useSimpleFSDirectory = true;
    private int termInfosIndexDivisor = 1;
    private SharedFieldComparatorSource scs;
    private boolean initializeHierarchyCache = true;
    private String redoLogFactoryClass = DefaultRedoLogFactory.class.getName();
    private RedoLogFactory redoLogFactory;
    private boolean closed = false;
    private static final Comparator<Fieldable> FIELDS_COMPARATOR_STORED;

    @Override
    protected void doInit() throws IOException {
        QueryHandlerContext context = this.getContext();
        if (this.path == null) {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        HashSet<NodeId> excludedIDs = new HashSet<NodeId>();
        if (context.getExcludedNodeId() != null) {
            excludedIDs.add(context.getExcludedNodeId());
        }
        this.synProvider = this.createSynonymProvider();
        this.directoryManager = this.createDirectoryManager();
        this.redoLogFactory = this.createRedoLogFactory();
        if (context.getParentHandler() instanceof SearchIndex) {
            SearchIndex sysIndex = (SearchIndex)context.getParentHandler();
            this.nsMappings = sysIndex.getNamespaceMappings();
        } else {
            File mapFile = new File(new File(this.path), NS_MAPPING_FILE);
            this.nsMappings = mapFile.exists() ? new FileBasedNamespaceMappings(mapFile) : new NSRegistryBasedNamespaceMappings(context.getNamespaceRegistry());
        }
        this.scs = new SharedFieldComparatorSource(FieldNames.PROPERTIES, context.getItemStateManager(), context.getHierarchyManager(), this.nsMappings);
        this.indexingConfig = this.createIndexingConfiguration(this.nsMappings);
        this.analyzer.setIndexingConfig(this.indexingConfig);
        this.parser = this.createParser();
        this.index = new MultiIndex(this, excludedIDs);
        if (this.index.numDocs() == 0) {
            Path rootPath = excludedIDs.isEmpty() ? JCR_SYSTEM_PATH : ROOT_PATH;
            this.index.createInitialIndex(context.getItemStateManager(), context.getRootId(), rootPath);
            this.checkPendingJournalChanges(context);
        }
        if (this.consistencyCheckEnabled && (this.index.getRedoLogApplied() || this.forceConsistencyCheck)) {
            log.info("Running consistency check...");
            try {
                ConsistencyCheck check = this.runConsistencyCheck();
                if (this.autoRepair) {
                    check.repair(true);
                } else {
                    List<ConsistencyCheckError> errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info("No errors detected.");
                    }
                    for (ConsistencyCheckError err : errors) {
                        log.info(err.toString());
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to run consistency check on index: " + e);
            }
        }
        this.spellChecker = this.createSpellChecker();
        log.info("Index initialized: {} Version: {}", new Object[]{this.path, this.index.getIndexFormatVersion()});
        if (!this.index.getIndexFormatVersion().equals(this.getIndexFormatVersion())) {
            log.warn("Using Version {} for reading. Please re-index version storage for optimal performance.", (Object)this.getIndexFormatVersion().getVersion());
        }
    }

    @Override
    public void addNode(NodeState node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    @Override
    public void deleteNode(NodeId id) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    @Override
    public void updateNodes(Iterator<NodeId> remove, Iterator<NodeState> add) throws RepositoryException, IOException {
        this.checkOpen();
        HashMap<NodeId, NodeState> aggregateRoots = new HashMap<NodeId, NodeState>();
        HashSet<NodeId> removedIds = new HashSet<NodeId>();
        HashSet<NodeId> addedIds = new HashSet<NodeId>();
        ArrayList<NodeId> removeCollection = new ArrayList<NodeId>();
        while (remove.hasNext()) {
            NodeId id = remove.next();
            removeCollection.add(id);
            removedIds.add(id);
        }
        ArrayList<Document> addCollection = new ArrayList<Document>();
        while (add.hasNext()) {
            NodeState state = add.next();
            if (state == null) continue;
            NodeId id = state.getNodeId();
            addedIds.add(id);
            this.retrieveAggregateRoot(state, aggregateRoots);
            try {
                addCollection.add(this.createDocument(state, this.getNamespaceMappings(), this.index.getIndexFormatVersion()));
            }
            catch (RepositoryException e) {
                log.warn("Exception while creating document for node: " + state.getNodeId() + ": " + e.toString());
            }
        }
        this.index.update(removeCollection, addCollection);
        aggregateRoots.keySet().removeAll(addedIds);
        this.retrieveAggregateRoot(removedIds, aggregateRoots);
        if (!aggregateRoots.isEmpty()) {
            ArrayList<Document> modified = new ArrayList<Document>(aggregateRoots.size());
            for (NodeState state : aggregateRoots.values()) {
                try {
                    modified.add(this.createDocument(state, this.getNamespaceMappings(), this.index.getIndexFormatVersion()));
                }
                catch (RepositoryException e) {
                    log.warn("Exception while creating document for node: " + state.getNodeId(), (Throwable)e);
                }
            }
            this.index.update(aggregateRoots.keySet(), modified);
        }
    }

    @Override
    public ExecutableQuery createExecutableQuery(SessionContext sessionContext, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(sessionContext, this, this.getContext().getPropertyTypeRegistry(), statement, language, (QueryNodeFactory)this.getQueryNodeFactory());
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<NodeId> getWeaklyReferringNodes(NodeId id) throws RepositoryException, IOException {
        final ArrayList docs = new ArrayList();
        ArrayList<NodeId> ids = new ArrayList<NodeId>();
        IndexReader reader = this.getIndexReader();
        try {
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                TermQuery q = new TermQuery(new Term(FieldNames.WEAK_REFS, id.toString()));
                searcher.search((Query)q, new AbstractHitCollector(){

                    @Override
                    public void collect(int doc, float score) {
                        docs.add(doc);
                    }
                });
            }
            finally {
                searcher.close();
            }
            for (Integer doc : docs) {
                Document d = reader.document(doc, FieldSelectors.UUID);
                ids.add(new NodeId(d.get(FieldNames.UUID)));
            }
        }
        finally {
            Util.closeOrRelease(reader);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Document> getNodeDocuments(NodeId id) throws RepositoryException, IOException {
        final ArrayList docIds = new ArrayList(1);
        ArrayList<Document> docs = new ArrayList<Document>();
        IndexReader reader = this.getIndexReader();
        try {
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                TermQuery q = new TermQuery(new Term(FieldNames.UUID, id.toString()));
                searcher.search((Query)q, new AbstractHitCollector(){

                    @Override
                    protected void collect(int doc, float score) {
                        docIds.add(doc);
                    }
                });
                for (Integer docId : docIds) {
                    docs.add(reader.document(docId, FieldSelectors.UUID_AND_PARENT));
                }
            }
            finally {
                searcher.close();
            }
        }
        finally {
            Util.closeOrRelease(reader);
        }
        return docs;
    }

    protected DefaultQueryNodeFactory getQueryNodeFactory() {
        return DEFAULT_QUERY_NODE_FACTORY;
    }

    public void flush() throws RepositoryException {
        try {
            this.index.waitUntilIndexingQueueIsEmpty();
            this.index.safeFlush();
            this.index.waitUntilIndexingQueueIsEmpty();
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to flush the index", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.synonymProviderConfigFs != null) {
            try {
                this.synonymProviderConfigFs.close();
            }
            catch (FileSystemException e) {
                log.warn("Exception while closing FileSystem", (Throwable)e);
            }
        }
        if (this.spellChecker != null) {
            this.spellChecker.close();
        }
        this.index.close();
        this.getContext().destroy();
        super.close();
        this.closed = true;
        log.info("Index closed: " + this.path);
    }

    public MultiColumnQueryHits executeQuery(SessionImpl session, AbstractQueryImpl queryImpl, Query query, Path[] orderProps, boolean[] orderSpecs, String[] orderFuncs, long resultFetchHint) throws IOException {
        this.checkOpen();
        Sort sort = new Sort(this.createSortFields(orderProps, orderSpecs, orderFuncs));
        final IndexReader reader = this.getIndexReader(queryImpl.needsSystemTree());
        JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(session, reader, this.getContext().getItemStateManager());
        searcher.setSimilarity(this.getSimilarity());
        return new FilterMultiColumnQueryHits(searcher.execute(query, sort, resultFetchHint, QueryImpl.DEFAULT_SELECTOR_NAME)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    Util.closeOrRelease(reader);
                }
            }
        };
    }

    public MultiColumnQueryHits executeQuery(SessionImpl session, MultiColumnQuery query, Ordering[] orderings, long resultFetchHint) throws IOException {
        this.checkOpen();
        final IndexReader reader = this.getIndexReader();
        JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(session, reader, this.getContext().getItemStateManager());
        searcher.setSimilarity(this.getSimilarity());
        return new FilterMultiColumnQueryHits(query.execute(searcher, orderings, resultFetchHint)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    Util.closeOrRelease(reader);
                }
            }
        };
    }

    public ExcerptProvider createExcerptProvider(Query query) throws IOException {
        ExcerptProvider ep;
        try {
            ep = (ExcerptProvider)this.excerptProviderClass.newInstance();
        }
        catch (Exception e) {
            throw Util.createIOException(e);
        }
        ep.init(query, this);
        return ep;
    }

    public Analyzer getTextAnalyzer() {
        return new LimitTokenCountAnalyzer(this.analyzer, this.getMaxFieldLength());
    }

    public String getTikaConfigPath() {
        return this.tikaConfigPath;
    }

    public void setTikaConfigPath(String tikaConfigPath) {
        this.tikaConfigPath = tikaConfigPath;
    }

    public String getForkJavaCommand() {
        return this.forkJavaCommand;
    }

    public void setForkJavaCommand(String command) {
        this.forkJavaCommand = command;
    }

    public Parser getParser() {
        return this.parser;
    }

    private Parser createParser() {
        URL url = null;
        if (this.tikaConfigPath != null) {
            File file = new File(this.tikaConfigPath);
            if (file.exists()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    log.warn("Invalid Tika configuration path: " + file, (Throwable)e);
                }
            } else {
                ClassLoader loader = SearchIndex.class.getClassLoader();
                url = loader.getResource(this.tikaConfigPath);
            }
        }
        if (url == null) {
            url = SearchIndex.class.getResource("tika-config.xml");
        }
        TikaConfig config = null;
        if (url != null) {
            try {
                config = new TikaConfig(url);
            }
            catch (Exception e) {
                log.warn("Tika configuration not available: " + url, (Throwable)e);
            }
        }
        if (config == null) {
            config = TikaConfig.getDefaultConfig();
        }
        if (this.forkJavaCommand != null) {
            ForkParser forkParser = new ForkParser(SearchIndex.class.getClassLoader(), (Parser)new AutoDetectParser(config));
            forkParser.setJavaCommand(this.forkJavaCommand);
            forkParser.setPoolSize(this.extractorPoolSize);
            return forkParser;
        }
        return new AutoDetectParser(config);
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public IndexingConfiguration getIndexingConfig() {
        return this.indexingConfig;
    }

    public SynonymProvider getSynonymProvider() {
        if (this.synProvider != null) {
            return this.synProvider;
        }
        QueryHandler handler = this.getContext().getParentHandler();
        if (handler instanceof SearchIndex) {
            return ((SearchIndex)handler).getSynonymProvider();
        }
        return null;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.getIndexReader(true);
    }

    public IndexFormatVersion getIndexFormatVersion() {
        if (this.indexFormatVersion == null) {
            SearchIndex parent;
            this.indexFormatVersion = this.getContext().getParentHandler() instanceof SearchIndex ? ((parent = (SearchIndex)this.getContext().getParentHandler()).getIndexFormatVersion().getVersion() < this.index.getIndexFormatVersion().getVersion() ? parent.getIndexFormatVersion() : this.index.getIndexFormatVersion()) : this.index.getIndexFormatVersion();
        }
        return this.indexFormatVersion;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public RedoLogFactory getRedoLogFactory() {
        return this.redoLogFactory;
    }

    public ConsistencyCheck runConsistencyCheck() throws IOException {
        return this.index.runConsistencyCheck();
    }

    protected IndexReader getIndexReader(boolean includeSystemIndex) throws IOException {
        MultiReader reader;
        QueryHandler parentHandler = this.getContext().getParentHandler();
        CachingMultiIndexReader parentReader = null;
        if (parentHandler instanceof SearchIndex && includeSystemIndex) {
            parentReader = ((SearchIndex)parentHandler).index.getIndexReader();
        }
        if (parentReader != null) {
            CachingMultiIndexReader[] readers = new CachingMultiIndexReader[]{this.index.getIndexReader(), parentReader};
            reader = new CombinedIndexReader(readers);
        } else {
            reader = this.index.getIndexReader();
        }
        return new JackrabbitIndexReader(reader);
    }

    protected SortField[] createSortFields(Path[] orderProps, boolean[] orderSpecs, String[] orderFuncs) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            if (orderProps[i].getLength() == 1 && NameConstants.JCR_SCORE.equals(orderProps[i].getName())) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            if ("upper-case".equals(orderFuncs[i])) {
                sortFields.add(new SortField(orderProps[i].getString(), new UpperCaseSortComparator(this.scs), !orderSpecs[i]));
                continue;
            }
            if ("lower-case".equals(orderFuncs[i])) {
                sortFields.add(new SortField(orderProps[i].getString(), new LowerCaseSortComparator(this.scs), !orderSpecs[i]));
                continue;
            }
            if ("normalize".equals(orderFuncs[i])) {
                sortFields.add(new SortField(orderProps[i].getString(), new NormalizeSortComparator(this.scs), !orderSpecs[i]));
                continue;
            }
            sortFields.add(new SortField(orderProps[i].getString(), this.scs, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    protected Ordering[] createOrderings(OrderingImpl[] orderings) throws RepositoryException {
        Ordering[] ords = new Ordering[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            ords[i] = Ordering.fromQOM(orderings[i], this.scs, this.nsMappings);
        }
        return ords;
    }

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.getContext().getExecutor(), this.parser);
        indexer.setSupportHighlighting(this.supportHighlighting);
        indexer.setIndexingConfiguration(this.indexingConfig);
        indexer.setIndexFormatVersion(indexFormatVersion);
        indexer.setMaxExtractLength(this.getMaxExtractLength());
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc, indexFormatVersion);
        return doc;
    }

    protected MultiIndex getIndex() {
        return this.index;
    }

    protected SharedFieldComparatorSource getSortComparatorSource() {
        return this.scs;
    }

    protected IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings) {
        Element docElement = this.getIndexingConfigurationDOM();
        if (docElement == null) {
            return null;
        }
        try {
            IndexingConfiguration idxCfg = (IndexingConfiguration)this.indexingConfigurationClass.newInstance();
            idxCfg.init(docElement, this.getContext(), namespaceMappings);
            return idxCfg;
        }
        catch (Exception e) {
            log.warn("Exception initializing indexing configuration from: " + this.indexingConfigPath, (Throwable)e);
            log.warn(this.indexingConfigPath + " ignored.");
            return null;
        }
    }

    protected SynonymProvider createSynonymProvider() {
        SynonymProvider sp = null;
        if (this.synonymProviderClass != null) {
            try {
                sp = (SynonymProvider)this.synonymProviderClass.newInstance();
                sp.initialize(this.createSynonymProviderConfigResource());
            }
            catch (Exception e) {
                log.warn("Exception initializing synonym provider: " + this.synonymProviderClass, (Throwable)e);
                sp = null;
            }
        }
        return sp;
    }

    protected DirectoryManager createDirectoryManager() throws IOException {
        try {
            Class<?> clazz = Class.forName(this.directoryManagerClass);
            if (!DirectoryManager.class.isAssignableFrom(clazz)) {
                throw new IOException(this.directoryManagerClass + " is not a DirectoryManager implementation");
            }
            DirectoryManager df = (DirectoryManager)clazz.newInstance();
            df.init(this);
            return df;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    protected RedoLogFactory createRedoLogFactory() throws IOException {
        try {
            Class<?> clazz = Class.forName(this.redoLogFactoryClass);
            if (!RedoLogFactory.class.isAssignableFrom(clazz)) {
                throw new IOException(this.redoLogFactoryClass + " is not a RedoLogFactory implementation");
            }
            return (RedoLogFactory)clazz.newInstance();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    protected FileSystemResource createSynonymProviderConfigResource() throws FileSystemException, IOException {
        if (this.synonymProviderConfigPath != null) {
            FileSystemResource fsr;
            if (this.synonymProviderConfigPath.endsWith("/")) {
                throw new FileSystemException("Invalid synonymProviderConfigPath: " + this.synonymProviderConfigPath);
            }
            if (this.fs == null) {
                this.fs = new LocalFileSystem();
                int lastSeparator = this.synonymProviderConfigPath.lastIndexOf(47);
                if (lastSeparator != -1) {
                    File root = new File(this.path, this.synonymProviderConfigPath.substring(0, lastSeparator));
                    ((LocalFileSystem)this.fs).setRoot(root.getCanonicalFile());
                    this.fs.init();
                    fsr = new FileSystemResource(this.fs, this.synonymProviderConfigPath.substring(lastSeparator + 1));
                } else {
                    ((LocalFileSystem)this.fs).setPath(this.path);
                    this.fs.init();
                    fsr = new FileSystemResource(this.fs, this.synonymProviderConfigPath);
                }
                this.synonymProviderConfigFs = this.fs;
            } else {
                fsr = new FileSystemResource(this.fs, this.synonymProviderConfigPath);
            }
            return fsr;
        }
        return null;
    }

    protected SpellChecker createSpellChecker() {
        SpellChecker spCheck = null;
        if (this.spellCheckerClass != null) {
            try {
                spCheck = (SpellChecker)this.spellCheckerClass.newInstance();
                spCheck.init(this);
            }
            catch (Exception e) {
                log.warn("Exception initializing spell checker: " + this.spellCheckerClass, (Throwable)e);
            }
        }
        return spCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element getIndexingConfigurationDOM() {
        if (this.indexingConfiguration != null) {
            return this.indexingConfiguration;
        }
        if (this.indexingConfigPath == null) {
            return null;
        }
        File config = new File(this.indexingConfigPath);
        InputStream configStream = null;
        if (!config.exists()) {
            configStream = this.getClass().getResourceAsStream(this.indexingConfigPath);
            if (configStream == null) {
                log.warn("File does not exist: " + this.indexingConfigPath);
                return null;
            }
        } else if (!config.canRead()) {
            log.warn("Cannot read file: " + this.indexingConfigPath);
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new IndexingConfigurationEntityResolver());
            this.indexingConfiguration = configStream != null ? builder.parse(configStream).getDocumentElement() : builder.parse(config).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            log.warn("Unable to create XML parser", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Exception parsing " + this.indexingConfigPath, (Throwable)e);
        }
        catch (SAXException e) {
            log.warn("Exception parsing " + this.indexingConfigPath, (Throwable)e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {}
            }
        }
        return this.indexingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeAggregatedNodeIndexes(NodeState state, Document doc, IndexFormatVersion ifv) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                ItemStateManager ism = this.getContext().getItemStateManager();
                for (AggregateRule aggregateRule : aggregateRules) {
                    PropertyState[] propStates;
                    boolean ruleMatched = false;
                    NodeState[] aggregates = aggregateRule.getAggregatedNodeStates(state);
                    if (aggregates != null) {
                        ruleMatched = true;
                        for (NodeState aggregate : aggregates) {
                            Document aDoc = this.createDocument(aggregate, this.getNamespaceMappings(), ifv);
                            Fieldable[] fulltextFields = aDoc.getFieldables(FieldNames.FULLTEXT);
                            if (fulltextFields == null) continue;
                            for (Fieldable fulltextField : fulltextFields) {
                                doc.add(fulltextField);
                            }
                            doc.add(new Field(FieldNames.AGGREGATED_NODE_UUID, false, aggregate.getNodeId().toString(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
                        }
                        Fieldable[] fulltextFields = doc.getFieldables(FieldNames.FULLTEXT);
                        doc.removeFields(FieldNames.FULLTEXT);
                        Arrays.sort(fulltextFields, FIELDS_COMPARATOR_STORED);
                        for (Fieldable f : fulltextFields) {
                            doc.add(f);
                        }
                    }
                    if ((propStates = aggregateRule.getAggregatedPropertyStates(state)) != null) {
                        ruleMatched = true;
                        for (PropertyState propState : propStates) {
                            String namePrefix = FieldNames.createNamedValue(this.getNamespaceMappings().translateName(propState.getName()), "");
                            NodeState parent = (NodeState)ism.getItemState(propState.getParentId());
                            Document aDoc = this.createDocument(parent, this.getNamespaceMappings(), ifv);
                            try {
                                Fieldable[] fields;
                                for (Fieldable field : fields = aDoc.getFieldables(FieldNames.PROPERTIES)) {
                                    TokenStream tokenStream = field.tokenStreamValue();
                                    TermAttribute termAttribute = tokenStream.addAttribute(TermAttribute.class);
                                    PayloadAttribute payloadAttribute = tokenStream.addAttribute(PayloadAttribute.class);
                                    tokenStream.incrementToken();
                                    tokenStream.end();
                                    tokenStream.close();
                                    String value = new String(termAttribute.termBuffer(), 0, termAttribute.termLength());
                                    if (!value.startsWith(namePrefix)) continue;
                                    String rawValue = value.substring(namePrefix.length());
                                    Path p = this.getRelativePath(state, propState);
                                    String path = this.getNamespaceMappings().translatePath(p);
                                    value = FieldNames.createNamedValue(path, rawValue);
                                    termAttribute.setTermBuffer(value);
                                    PropertyMetaData pdm = PropertyMetaData.fromByteArray(payloadAttribute.getPayload().getData());
                                    doc.add(new Field(field.name(), new SingletonTokenStream(value, pdm.getPropertyType())));
                                    doc.add(new Field(FieldNames.AGGREGATED_NODE_UUID, false, parent.getNodeId().toString(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
                                    if (pdm.getPropertyType() != 1) continue;
                                    Field ft = new Field(FieldNames.FULLTEXT, false, rawValue, Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO);
                                    doc.add(ft);
                                }
                            }
                            finally {
                                Util.disposeDocument(aDoc);
                            }
                        }
                    }
                    if (!ruleMatched) {
                        continue;
                    }
                    break;
                }
            }
            catch (NoSuchItemStateException e) {
                log.info("Exception while building indexing aggregate for {}. Node is not available {}.", (Object)state.getNodeId(), (Object)e.getMessage());
            }
            catch (Exception e) {
                log.warn("Exception while building indexing aggregate for " + state.getNodeId(), (Throwable)e);
            }
        }
    }

    protected Path getRelativePath(NodeState nodeState, PropertyState propState) throws RepositoryException, ItemStateException {
        HierarchyManager hmgr = this.getContext().getHierarchyManager();
        Path nodePath = hmgr.getPath(nodeState.getId());
        Path propPath = hmgr.getPath(propState.getId());
        Path p = nodePath.computeRelativePath(propPath);
        boolean clean = true;
        Path.Element[] elements = p.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].getIndex() == 0) continue;
            elements[i] = PATH_FACTORY.createElement(elements[i].getName());
            clean = false;
        }
        if (!clean) {
            p = PATH_FACTORY.create(elements);
        }
        return p.getNormalizedPath();
    }

    protected void retrieveAggregateRoot(NodeState state, Map<NodeId, NodeState> aggregates) {
        this.retrieveAggregateRoot(state, aggregates, state.getNodeId().toString(), 0L);
    }

    private void retrieveAggregateRoot(NodeState state, Map<NodeId, NodeState> aggregates, String originNodeId, long level) {
        if (this.indexingConfig == null) {
            return;
        }
        AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
        if (aggregateRules == null) {
            return;
        }
        for (AggregateRule aggregateRule : aggregateRules) {
            NodeState root = null;
            try {
                root = aggregateRule.getAggregateRoot(state);
            }
            catch (Exception e) {
                log.warn("Unable to get aggregate root for " + state.getNodeId(), (Throwable)e);
            }
            if (root == null) continue;
            level = root.getNodeTypeName().equals(state.getNodeTypeName()) ? ++level : 0L;
            if (aggregateRule.getRecursiveAggregationLimit() == 0L || aggregateRule.getRecursiveAggregationLimit() != 0L && level <= aggregateRule.getRecursiveAggregationLimit()) {
                if (aggregates.put(root.getNodeId(), root) != null) continue;
                this.retrieveAggregateRoot(root, aggregates, originNodeId, level);
                continue;
            }
            log.warn("Reached {} levels of recursive aggregation for nodeId {}, type {}, will stop at nodeId {}. Are you sure this did not occur by mistake? Please check the indexing-configuration.xml.", new Object[]{level, originNodeId, root.getNodeTypeName(), root.getNodeId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveAggregateRoot(Set<NodeId> removedIds, Map<NodeId, NodeState> aggregates) {
        if (removedIds.isEmpty() || this.indexingConfig == null) {
            return;
        }
        AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
        if (aggregateRules == null) {
            return;
        }
        int found = 0;
        long time = System.currentTimeMillis();
        try {
            CachingMultiIndexReader reader = this.index.getIndexReader();
            try {
                Term aggregateIds = new Term(FieldNames.AGGREGATED_NODE_UUID, "");
                TermDocs tDocs = reader.termDocs();
                try {
                    ItemStateManager ism = this.getContext().getItemStateManager();
                    for (NodeId id : removedIds) {
                        aggregateIds = aggregateIds.createTerm(id.toString());
                        tDocs.seek(aggregateIds);
                        while (tDocs.next()) {
                            Document doc = reader.document(tDocs.doc(), FieldSelectors.UUID);
                            NodeId nId = new NodeId(doc.get(FieldNames.UUID));
                            NodeState nodeState = (NodeState)ism.getItemState(nId);
                            aggregates.put(nId, nodeState);
                            ++found;
                            int sizeBefore = aggregates.size();
                            this.retrieveAggregateRoot(nodeState, aggregates);
                            found += aggregates.size() - sizeBefore;
                        }
                    }
                }
                finally {
                    tDocs.close();
                }
            }
            finally {
                reader.release();
            }
        }
        catch (NoSuchItemStateException e) {
            log.info("Exception while retrieving aggregate roots. Node is not available {}.", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.warn("Exception while retrieving aggregate roots", (Throwable)e);
        }
        time = System.currentTimeMillis() - time;
        log.debug("Retrieved {} aggregate roots in {} ms.", (Object)found, (Object)time);
    }

    public void setAnalyzer(String analyzerClassName) {
        this.analyzer.setDefaultAnalyzerClass(analyzerClassName);
    }

    public String getAnalyzer() {
        return this.analyzer.getDefaultAnalyzerClass();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public int getMinMergeDocs() {
        return this.minMergeDocs;
    }

    public void setVolatileIdleTime(int volatileIdleTime) {
        this.volatileIdleTime = volatileIdleTime;
    }

    public int getVolatileIdleTime() {
        return this.volatileIdleTime;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setRespectDocumentOrder(boolean docOrder) {
        this.documentOrder = docOrder;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setForceConsistencyCheck(boolean b) {
        this.forceConsistencyCheck = b;
    }

    public boolean getForceConsistencyCheck() {
        return this.forceConsistencyCheck;
    }

    public void setAutoRepair(boolean b) {
        this.autoRepair = b;
    }

    public boolean getAutoRepair() {
        return this.autoRepair;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxFieldLength(int length) {
        this.maxFieldLength = length;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxExtractLength(int length) {
        this.maxExtractLength = length;
    }

    public int getMaxExtractLength() {
        if (this.maxExtractLength < 0) {
            return -this.maxExtractLength * this.maxFieldLength;
        }
        return this.maxExtractLength;
    }

    public void setTextFilterClasses(String filterClasses) {
        log.warn("The textFilterClasses configuration parameter has been deprecated, and the configured value will be ignored: {}", (Object)filterClasses);
    }

    public String getTextFilterClasses() {
        return "deprectated";
    }

    public void setResultFetchSize(int size) {
        this.resultFetchSize = size;
    }

    public int getResultFetchSize() {
        return this.resultFetchSize;
    }

    public void setExtractorPoolSize(int numThreads) {
        if (numThreads < 0) {
            numThreads = 0;
        }
        this.extractorPoolSize = numThreads;
    }

    public int getExtractorPoolSize() {
        return this.extractorPoolSize;
    }

    public void setExtractorBackLogSize(int backLog) {
        this.extractorBackLog = backLog;
    }

    public int getExtractorBackLogSize() {
        return this.extractorBackLog;
    }

    public void setExtractorTimeout(long timeout) {
        this.extractorTimeout = timeout;
    }

    public long getExtractorTimeout() {
        return this.extractorTimeout;
    }

    public void setSizeEstimate(boolean b) {
        if (b) {
            log.info("Size estimation is enabled");
        }
        this.sizeEstimate = b;
    }

    public boolean getSizeEstimate() {
        return this.sizeEstimate;
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public boolean getSupportHighlighting() {
        return this.supportHighlighting;
    }

    public void setExcerptProviderClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (ExcerptProvider.class.isAssignableFrom(clazz)) {
                this.excerptProviderClass = clazz;
            } else {
                log.warn("Invalid value for excerptProviderClass, {} does not implement ExcerptProvider interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for excerptProviderClass, class {} not found.", (Object)className);
        }
    }

    public String getExcerptProviderClass() {
        return this.excerptProviderClass.getName();
    }

    public void setIndexingConfiguration(String path) {
        this.indexingConfigPath = path;
    }

    public String getIndexingConfiguration() {
        return this.indexingConfigPath;
    }

    public void setIndexingConfigurationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (IndexingConfiguration.class.isAssignableFrom(clazz)) {
                this.indexingConfigurationClass = clazz;
            } else {
                log.warn("Invalid value for indexingConfigurationClass, {} does not implement IndexingConfiguration interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for indexingConfigurationClass, class {} not found.", (Object)className);
        }
    }

    public String getIndexingConfigurationClass() {
        return this.indexingConfigurationClass.getName();
    }

    public void setSynonymProviderClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (SynonymProvider.class.isAssignableFrom(clazz)) {
                this.synonymProviderClass = clazz;
            } else {
                log.warn("Invalid value for synonymProviderClass, {} does not implement SynonymProvider interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for synonymProviderClass, class {} not found.", (Object)className);
        }
    }

    public String getSynonymProviderClass() {
        if (this.synonymProviderClass != null) {
            return this.synonymProviderClass.getName();
        }
        return null;
    }

    public void setSpellCheckerClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (SpellChecker.class.isAssignableFrom(clazz)) {
                this.spellCheckerClass = clazz;
            } else {
                log.warn("Invalid value for spellCheckerClass, {} does not implement SpellChecker interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for spellCheckerClass, class {} not found.", (Object)className);
        }
    }

    public String getSpellCheckerClass() {
        if (this.spellCheckerClass != null) {
            return this.spellCheckerClass.getName();
        }
        return null;
    }

    public void setEnableConsistencyCheck(boolean b) {
        this.consistencyCheckEnabled = b;
    }

    public boolean getEnableConsistencyCheck() {
        return this.consistencyCheckEnabled;
    }

    public void setSynonymProviderConfigPath(String path) {
        this.synonymProviderConfigPath = path;
    }

    public String getSynonymProviderConfigPath() {
        return this.synonymProviderConfigPath;
    }

    public void setSimilarityClass(String className) {
        try {
            Class<?> similarityClass = Class.forName(className);
            this.similarity = (Similarity)similarityClass.newInstance();
        }
        catch (Exception e) {
            log.warn("Invalid Similarity class: " + className, (Throwable)e);
        }
    }

    public String getSimilarityClass() {
        return this.similarity.getClass().getName();
    }

    public void setMaxVolatileIndexSize(long maxVolatileIndexSize) {
        this.maxVolatileIndexSize = maxVolatileIndexSize;
    }

    public long getMaxVolatileIndexSize() {
        return this.maxVolatileIndexSize;
    }

    public String getDirectoryManagerClass() {
        return this.directoryManagerClass;
    }

    public void setDirectoryManagerClass(String className) {
        this.directoryManagerClass = className;
    }

    public void setUseSimpleFSDirectory(boolean useSimpleFSDirectory) {
        this.useSimpleFSDirectory = useSimpleFSDirectory;
    }

    public boolean isUseSimpleFSDirectory() {
        return this.useSimpleFSDirectory;
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public void setTermInfosIndexDivisor(int termInfosIndexDivisor) {
        this.termInfosIndexDivisor = termInfosIndexDivisor;
    }

    public boolean isInitializeHierarchyCache() {
        return this.initializeHierarchyCache;
    }

    public void setInitializeHierarchyCache(boolean initializeHierarchyCache) {
        this.initializeHierarchyCache = initializeHierarchyCache;
    }

    public long getMaxHistoryAge() {
        return this.maxHistoryAge;
    }

    public void setMaxHistoryAge(long maxHistoryAge) {
        this.maxHistoryAge = maxHistoryAge;
    }

    public String getRedoLogFactoryClass() {
        return this.redoLogFactoryClass;
    }

    public void setRedoLogFactoryClass(String className) {
        this.redoLogFactoryClass = className;
    }

    private void checkPendingJournalChanges(QueryHandlerContext context) {
        ClusterNode cn = context.getClusterNode();
        if (cn == null) {
            return;
        }
        ArrayList<NodeId> addedIds = new ArrayList<NodeId>();
        long rev = cn.getRevision();
        List<ChangeLogRecord> changes = this.getChangeLogRecords(rev, context.getWorkspace());
        for (ChangeLogRecord record : changes) {
            for (ItemState state : record.getChanges().addedStates()) {
                if (!state.isNode()) continue;
                addedIds.add((NodeId)state.getId());
            }
        }
        if (!addedIds.isEmpty()) {
            List empty = Collections.emptyList();
            try {
                this.updateNodes(addedIds.iterator(), empty.iterator());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ChangeLogRecord> getChangeLogRecords(long revision, final String workspace) {
        log.debug("Get changes from the Journal for revision {} and workspace {}.", (Object)revision, (Object)workspace);
        ClusterNode cn = this.getContext().getClusterNode();
        if (cn == null) {
            return Collections.emptyList();
        }
        Journal journal = cn.getJournal();
        final ArrayList<ChangeLogRecord> events = new ArrayList<ChangeLogRecord>();
        ClusterRecordDeserializer deserializer = new ClusterRecordDeserializer();
        RecordIterator records = null;
        try {
            records = journal.getRecords(revision);
            while (records.hasNext()) {
                Record record = records.nextRecord();
                if (!record.getProducerId().equals(cn.getId())) continue;
                ClusterRecord r = null;
                try {
                    r = deserializer.deserialize(record);
                }
                catch (JournalException e) {
                    log.error("Unable to read revision '" + record.getRevision() + "'.", (Throwable)e);
                }
                if (r == null) continue;
                r.process(new ClusterRecordProcessor(){

                    @Override
                    public void process(ChangeLogRecord record) {
                        String eventW = record.getWorkspace();
                        if (eventW != null ? eventW.equals(workspace) : workspace == null) {
                            events.add(record);
                        }
                    }

                    @Override
                    public void process(LockRecord record) {
                    }

                    @Override
                    public void process(NamespaceRecord record) {
                    }

                    @Override
                    public void process(NodeTypeRecord record) {
                    }

                    @Override
                    public void process(PrivilegeRecord record) {
                    }

                    @Override
                    public void process(WorkspaceRecord record) {
                    }
                });
            }
        }
        catch (JournalException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        finally {
            if (records != null) {
                records.close();
            }
        }
        return events;
    }

    static {
        try {
            JCR_SYSTEM_PATH = PATH_FACTORY.create(ROOT_PATH, NameConstants.JCR_SYSTEM, false);
        }
        catch (RepositoryException e) {
            throw new InternalError(e.getMessage());
        }
        FIELDS_COMPARATOR_STORED = new Comparator<Fieldable>(){

            @Override
            public int compare(Fieldable o1, Fieldable o2) {
                return Boolean.valueOf(o2.isStored()).compareTo(o1.isStored());
            }
        };
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver,
    MultiIndexReader {
        private final CachingMultiIndexReader[] subReaders;

        public CombinedIndexReader(CachingMultiIndexReader[] indexReaders) {
            super((IndexReader[])indexReaders);
            this.subReaders = indexReaders;
        }

        @Override
        public int[] getParents(int n, int[] docNumbers) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumbers(this, docNumbers);
        }

        @Override
        public IndexReader[] getIndexReaders() {
            IndexReader[] readers = new IndexReader[this.subReaders.length];
            System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
            return readers;
        }

        @Override
        public void release() throws IOException {
            for (CachingMultiIndexReader subReader : this.subReaders) {
                subReader.release();
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof CombinedIndexReader) {
                CombinedIndexReader other = (CombinedIndexReader)obj;
                return Arrays.equals(this.subReaders, other.subReaders);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (CachingMultiIndexReader subReader : this.subReaders) {
                hash = 31 * hash + subReader.hashCode();
            }
            return hash;
        }

        @Override
        public ForeignSegmentDocId createDocId(NodeId id) throws IOException {
            for (CachingMultiIndexReader subReader : this.subReaders) {
                ForeignSegmentDocId doc = subReader.createDocId(id);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        @Override
        public int getDocumentNumber(ForeignSegmentDocId docId) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                int realDoc = subReader.getDocumentNumber(docId);
                if (realDoc < 0) continue;
                return realDoc + this.starts[i];
            }
            return -1;
        }
    }
}

