/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class MockComponentContextTest {
    private ComponentContext underTest;

    @Before
    public void setUp() {
        this.underTest = MockOsgi.newComponentContext();
    }

    @Test
    public void testBundleContext() {
        Assert.assertNotNull((Object)this.underTest.getBundleContext());
    }

    @Test
    public void testInitialProperties() {
        Assert.assertEquals((long)0L, (long)this.underTest.getProperties().size());
    }

    @Test
    public void testProvidedProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("prop1", "value1");
        ((Dictionary)props).put("prop2", 25);
        ComponentContext componentContextWithProperties = MockOsgi.newComponentContext(props);
        Dictionary contextProps = componentContextWithProperties.getProperties();
        Assert.assertEquals((long)2L, (long)contextProps.size());
        Assert.assertEquals((Object)"value1", contextProps.get("prop1"));
        Assert.assertEquals((Object)25, contextProps.get("prop2"));
    }

    @Test
    public void testLocateService() {
        String clazz = String.class.getName();
        Object service = new Object();
        this.underTest.getBundleContext().registerService(clazz, service, null);
        ServiceReference ref = this.underTest.getBundleContext().getServiceReference(clazz);
        Object locatedService = this.underTest.locateService(null, ref);
        Assert.assertSame((Object)service, (Object)locatedService);
    }

    @Test
    public void testIgnoredMethods() {
        this.underTest.enableComponent("myComponent");
        this.underTest.disableComponent("myComponent");
    }

    @Test
    public void testGetUsingBundle() {
        Assert.assertNull((Object)this.underTest.getUsingBundle());
        Bundle usingBundle = (Bundle)Mockito.mock(Bundle.class);
        ComponentContext contextWithUsingBundle = MockOsgi.componentContext().usingBundle(usingBundle).build();
        Assert.assertSame((Object)usingBundle, (Object)contextWithUsingBundle.getUsingBundle());
    }
}

