/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.owasp.esapi.Logger;
import org.owasp.esapi.logging.appender.LogAppender;
import org.owasp.esapi.logging.cleaning.LogScrubber;
import org.owasp.esapi.logging.slf4j.Slf4JLogBridge;
import org.owasp.esapi.logging.slf4j.Slf4JLogLevelHandler;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class Slf4JLogBridgeImpl
implements Slf4JLogBridge {
    private static final IMarkerFactory MARKER_FACTORY = new BasicMarkerFactory();
    private final Map<Integer, Slf4JLogLevelHandler> esapiSlfLevelMap;
    private final LogScrubber scrubber;
    private final LogAppender appender;

    public Slf4JLogBridgeImpl(LogAppender messageAppender, LogScrubber logScrubber, Map<Integer, Slf4JLogLevelHandler> esapiSlfHandlerMap) {
        this.esapiSlfLevelMap = new HashMap<Integer, Slf4JLogLevelHandler>(esapiSlfHandlerMap);
        this.scrubber = logScrubber;
        this.appender = messageAppender;
    }

    @Override
    public void log(org.slf4j.Logger logger, int esapiLevel, Logger.EventType type, String message) {
        Slf4JLogLevelHandler handler = this.esapiSlfLevelMap.get(esapiLevel);
        if (handler == null) {
            throw new IllegalArgumentException("Unable to lookup SLF4J level mapping for esapi value of " + esapiLevel);
        }
        if (handler.isEnabled(logger)) {
            type = type == null ? Logger.EVENT_UNSPECIFIED : type;
            String fullMessage = this.appender.appendTo(logger.getName(), type, message);
            String cleanString = this.scrubber.cleanMessage(fullMessage);
            Marker typeMarker = MARKER_FACTORY.getMarker(type.toString());
            handler.log(logger, typeMarker, cleanString);
        }
    }

    @Override
    public void log(org.slf4j.Logger logger, int esapiLevel, Logger.EventType type, String message, Throwable throwable) {
        Slf4JLogLevelHandler handler = this.esapiSlfLevelMap.get(esapiLevel);
        if (handler == null) {
            throw new IllegalArgumentException("Unable to lookup SLF4J level mapping for esapi value of " + esapiLevel);
        }
        if (handler.isEnabled(logger)) {
            type = type == null ? Logger.EVENT_UNSPECIFIED : type;
            String fullMessage = this.appender.appendTo(logger.getName(), type, message);
            String cleanString = this.scrubber.cleanMessage(fullMessage);
            Marker typeMarker = MARKER_FACTORY.getMarker(type.toString());
            handler.log(logger, typeMarker, cleanString, throwable);
        }
    }
}

