/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;

public class Geostationary
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "Geostationary";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        this.readStandardParams(ds, ctv);
        double subLonDegrees = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        if (Double.isNaN(subLonDegrees)) {
            throw new IllegalArgumentException("Must specify longitude_of_projection_origin");
        }
        double perspective_point_height = this.readAttributeDouble(ctv, "perspective_point_height", Double.NaN);
        if (Double.isNaN(perspective_point_height)) {
            throw new IllegalArgumentException("Must specify perspective_point_height");
        }
        double semi_minor_axis = this.readAttributeDouble(ctv, "semi_minor_axis", Double.NaN);
        if (Double.isNaN(semi_minor_axis)) {
            throw new IllegalArgumentException("Must specify semi_minor_axis");
        }
        double semi_major_axis = this.readAttributeDouble(ctv, "semi_major_axis", Double.NaN);
        if (Double.isNaN(semi_major_axis)) {
            throw new IllegalArgumentException("Must specify semi_major_axis");
        }
        double inv_flattening = this.readAttributeDouble(ctv, "inverse_flattening", Double.NaN);
        String sweep_angle = this.readAttribute(ctv, "sweep_angle_axis", null);
        String fixed_angle = this.readAttribute(ctv, "fixed_angle_axis", null);
        if (sweep_angle == null && fixed_angle == null) {
            throw new IllegalArgumentException("Must specify sweep_angle_axis or fixed_angle_axis");
        }
        boolean isSweepX = sweep_angle != null ? sweep_angle.equals("x") : fixed_angle.equals("y");
        ucar.unidata.geoloc.projection.sat.Geostationary proj = new ucar.unidata.geoloc.projection.sat.Geostationary(subLonDegrees, perspective_point_height, semi_minor_axis, semi_major_axis, inv_flattening, isSweepX);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

