/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GetElementsByTagName {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final String DEFAULT_ELEMENT_NAME = "*";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;

    public static void print(PrintWriter printWriter, Document document, String string, String string2) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null) {
            return;
        }
        if (string2 == null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                GetElementsByTagName.print(printWriter, element, element.getAttributes());
            }
        } else {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap.getNamedItem(string2) == null) continue;
                GetElementsByTagName.print(printWriter, element, namedNodeMap);
            }
        }
    }

    protected static void print(PrintWriter printWriter, Element element, NamedNodeMap namedNodeMap) {
        printWriter.print('<');
        printWriter.print(element.getNodeName());
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                printWriter.print(' ');
                printWriter.print(attr.getNodeName());
                printWriter.print("=\"");
                printWriter.print(GetElementsByTagName.normalize(attr.getNodeValue()));
                printWriter.print('\"');
            }
        }
        printWriter.println('>');
        printWriter.flush();
    }

    protected static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            GetElementsByTagName.printUsage();
            System.exit(1);
        }
        PrintWriter printWriter = new PrintWriter(System.out);
        ParserWrapper parserWrapper = null;
        String string = DEFAULT_ELEMENT_NAME;
        String string2 = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        boolean bl10 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string3 = stringArray[i];
            if (string3.startsWith("-")) {
                object2 = string3.substring(1);
                if (((String)object2).equals("p")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    object = stringArray[i];
                    try {
                        parserWrapper = (ParserWrapper)Class.forName((String)object).newInstance();
                    }
                    catch (Exception exception) {
                        parserWrapper = null;
                        System.err.println("error: Unable to instantiate parser (" + (String)object + ")");
                    }
                    continue;
                }
                if (((String)object2).equals("e")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -e option.");
                    }
                    string = stringArray[i];
                    continue;
                }
                if (((String)object2).equals("a")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -a option.");
                    }
                    string2 = stringArray[i];
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("n")) {
                    bl = ((String)object2).equals("n");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("v")) {
                    bl2 = ((String)object2).equals("v");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("s")) {
                    bl3 = ((String)object2).equals("s");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("f")) {
                    bl4 = ((String)object2).equals("f");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("hs")) {
                    bl5 = ((String)object2).equals("hs");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("va")) {
                    bl6 = ((String)object2).equals("va");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("dv")) {
                    bl7 = ((String)object2).equals("dv");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xi")) {
                    bl8 = ((String)object2).equals("xi");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xb")) {
                    bl9 = ((String)object2).equals("xb");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xl")) {
                    bl10 = ((String)object2).equals("xl");
                    continue;
                }
                if (((String)object2).equals("h")) {
                    GetElementsByTagName.printUsage();
                    continue;
                }
            }
            if (parserWrapper == null) {
                try {
                    parserWrapper = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                    continue;
                }
            }
            try {
                parserWrapper.setFeature(NAMESPACES_FEATURE_ID, bl);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                parserWrapper.setFeature(VALIDATION_FEATURE_ID, bl2);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                parserWrapper.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                parserWrapper.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl4);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                parserWrapper.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl5);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                parserWrapper.setFeature(VALIDATE_ANNOTATIONS_ID, bl6);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                parserWrapper.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, bl7);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
            }
            try {
                parserWrapper.setFeature(XINCLUDE_FEATURE_ID, bl8);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
            }
            try {
                parserWrapper.setFeature(XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID, bl9);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
            }
            try {
                parserWrapper.setFeature(XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID, bl10);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
            }
            try {
                object2 = parserWrapper.parse(string3);
                GetElementsByTagName.print(printWriter, (Document)object2, string, string2);
                continue;
            }
            catch (SAXParseException sAXParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                    object2 = object;
                }
                ((Throwable)object2).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.GetElementsByTagName (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -e name     Specify element name for search.");
        System.err.println("  -a name     Specify attribute name for specified elements.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.println("  Element:    *");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

