﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CleanRooms {
namespace Model {

/**
 * <p>Details about the configured audience model association.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ConfiguredAudienceModelAssociation">AWS
 * API Reference</a></p>
 */
class ConfiguredAudienceModelAssociation {
 public:
  AWS_CLEANROOMS_API ConfiguredAudienceModelAssociation() = default;
  AWS_CLEANROOMS_API ConfiguredAudienceModelAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API ConfiguredAudienceModelAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A unique identifier of the configured audience model association.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ConfiguredAudienceModelAssociation& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the configured audience model
   * association.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ConfiguredAudienceModelAssociation& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the configured audience model that was used
   * for this configured audience model association.</p>
   */
  inline const Aws::String& GetConfiguredAudienceModelArn() const { return m_configuredAudienceModelArn; }
  inline bool ConfiguredAudienceModelArnHasBeenSet() const { return m_configuredAudienceModelArnHasBeenSet; }
  template <typename ConfiguredAudienceModelArnT = Aws::String>
  void SetConfiguredAudienceModelArn(ConfiguredAudienceModelArnT&& value) {
    m_configuredAudienceModelArnHasBeenSet = true;
    m_configuredAudienceModelArn = std::forward<ConfiguredAudienceModelArnT>(value);
  }
  template <typename ConfiguredAudienceModelArnT = Aws::String>
  ConfiguredAudienceModelAssociation& WithConfiguredAudienceModelArn(ConfiguredAudienceModelArnT&& value) {
    SetConfiguredAudienceModelArn(std::forward<ConfiguredAudienceModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for the membership that contains this configured audience
   * model association.</p>
   */
  inline const Aws::String& GetMembershipId() const { return m_membershipId; }
  inline bool MembershipIdHasBeenSet() const { return m_membershipIdHasBeenSet; }
  template <typename MembershipIdT = Aws::String>
  void SetMembershipId(MembershipIdT&& value) {
    m_membershipIdHasBeenSet = true;
    m_membershipId = std::forward<MembershipIdT>(value);
  }
  template <typename MembershipIdT = Aws::String>
  ConfiguredAudienceModelAssociation& WithMembershipId(MembershipIdT&& value) {
    SetMembershipId(std::forward<MembershipIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the membership that contains this
   * configured audience model association.</p>
   */
  inline const Aws::String& GetMembershipArn() const { return m_membershipArn; }
  inline bool MembershipArnHasBeenSet() const { return m_membershipArnHasBeenSet; }
  template <typename MembershipArnT = Aws::String>
  void SetMembershipArn(MembershipArnT&& value) {
    m_membershipArnHasBeenSet = true;
    m_membershipArn = std::forward<MembershipArnT>(value);
  }
  template <typename MembershipArnT = Aws::String>
  ConfiguredAudienceModelAssociation& WithMembershipArn(MembershipArnT&& value) {
    SetMembershipArn(std::forward<MembershipArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier of the collaboration that contains this configured
   * audience model association.</p>
   */
  inline const Aws::String& GetCollaborationId() const { return m_collaborationId; }
  inline bool CollaborationIdHasBeenSet() const { return m_collaborationIdHasBeenSet; }
  template <typename CollaborationIdT = Aws::String>
  void SetCollaborationId(CollaborationIdT&& value) {
    m_collaborationIdHasBeenSet = true;
    m_collaborationId = std::forward<CollaborationIdT>(value);
  }
  template <typename CollaborationIdT = Aws::String>
  ConfiguredAudienceModelAssociation& WithCollaborationId(CollaborationIdT&& value) {
    SetCollaborationId(std::forward<CollaborationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the collaboration that contains this
   * configured audience model association.</p>
   */
  inline const Aws::String& GetCollaborationArn() const { return m_collaborationArn; }
  inline bool CollaborationArnHasBeenSet() const { return m_collaborationArnHasBeenSet; }
  template <typename CollaborationArnT = Aws::String>
  void SetCollaborationArn(CollaborationArnT&& value) {
    m_collaborationArnHasBeenSet = true;
    m_collaborationArn = std::forward<CollaborationArnT>(value);
  }
  template <typename CollaborationArnT = Aws::String>
  ConfiguredAudienceModelAssociation& WithCollaborationArn(CollaborationArnT&& value) {
    SetCollaborationArn(std::forward<CollaborationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configured audience model association.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ConfiguredAudienceModelAssociation& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When <code>TRUE</code>, indicates that the resource policy for the configured
   * audience model resource being associated is configured for Clean Rooms to manage
   * permissions related to the given collaboration. When <code>FALSE</code>,
   * indicates that the configured audience model resource owner will manage
   * permissions related to the given collaboration.</p>
   */
  inline bool GetManageResourcePolicies() const { return m_manageResourcePolicies; }
  inline bool ManageResourcePoliciesHasBeenSet() const { return m_manageResourcePoliciesHasBeenSet; }
  inline void SetManageResourcePolicies(bool value) {
    m_manageResourcePoliciesHasBeenSet = true;
    m_manageResourcePolicies = value;
  }
  inline ConfiguredAudienceModelAssociation& WithManageResourcePolicies(bool value) {
    SetManageResourcePolicies(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the configured audience model association.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  ConfiguredAudienceModelAssociation& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the configured audience model association was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  ConfiguredAudienceModelAssociation& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The most recent time at which the configured audience model association was
   * updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  inline bool UpdateTimeHasBeenSet() const { return m_updateTimeHasBeenSet; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  ConfiguredAudienceModelAssociation& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_configuredAudienceModelArn;
  bool m_configuredAudienceModelArnHasBeenSet = false;

  Aws::String m_membershipId;
  bool m_membershipIdHasBeenSet = false;

  Aws::String m_membershipArn;
  bool m_membershipArnHasBeenSet = false;

  Aws::String m_collaborationId;
  bool m_collaborationIdHasBeenSet = false;

  Aws::String m_collaborationArn;
  bool m_collaborationArnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  bool m_manageResourcePolicies{false};
  bool m_manageResourcePoliciesHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_createTime{};
  bool m_createTimeHasBeenSet = false;

  Aws::Utils::DateTime m_updateTime{};
  bool m_updateTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
