﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecs/ECS_EXPORTS.h>
#include <aws/ecs/model/Session.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ECS {
namespace Model {
class ExecuteCommandResult {
 public:
  AWS_ECS_API ExecuteCommandResult() = default;
  AWS_ECS_API ExecuteCommandResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ECS_API ExecuteCommandResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the cluster.</p>
   */
  inline const Aws::String& GetClusterArn() const { return m_clusterArn; }
  template <typename ClusterArnT = Aws::String>
  void SetClusterArn(ClusterArnT&& value) {
    m_clusterArnHasBeenSet = true;
    m_clusterArn = std::forward<ClusterArnT>(value);
  }
  template <typename ClusterArnT = Aws::String>
  ExecuteCommandResult& WithClusterArn(ClusterArnT&& value) {
    SetClusterArn(std::forward<ClusterArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the container.</p>
   */
  inline const Aws::String& GetContainerArn() const { return m_containerArn; }
  template <typename ContainerArnT = Aws::String>
  void SetContainerArn(ContainerArnT&& value) {
    m_containerArnHasBeenSet = true;
    m_containerArn = std::forward<ContainerArnT>(value);
  }
  template <typename ContainerArnT = Aws::String>
  ExecuteCommandResult& WithContainerArn(ContainerArnT&& value) {
    SetContainerArn(std::forward<ContainerArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the container.</p>
   */
  inline const Aws::String& GetContainerName() const { return m_containerName; }
  template <typename ContainerNameT = Aws::String>
  void SetContainerName(ContainerNameT&& value) {
    m_containerNameHasBeenSet = true;
    m_containerName = std::forward<ContainerNameT>(value);
  }
  template <typename ContainerNameT = Aws::String>
  ExecuteCommandResult& WithContainerName(ContainerNameT&& value) {
    SetContainerName(std::forward<ContainerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the execute command session is running in interactive
   * mode. Amazon ECS only supports initiating interactive sessions, so you must
   * specify <code>true</code> for this value.</p>
   */
  inline bool GetInteractive() const { return m_interactive; }
  inline void SetInteractive(bool value) {
    m_interactiveHasBeenSet = true;
    m_interactive = value;
  }
  inline ExecuteCommandResult& WithInteractive(bool value) {
    SetInteractive(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The details of the SSM session that was created for this instance of
   * execute-command.</p>
   */
  inline const Session& GetSession() const { return m_session; }
  template <typename SessionT = Session>
  void SetSession(SessionT&& value) {
    m_sessionHasBeenSet = true;
    m_session = std::forward<SessionT>(value);
  }
  template <typename SessionT = Session>
  ExecuteCommandResult& WithSession(SessionT&& value) {
    SetSession(std::forward<SessionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the task.</p>
   */
  inline const Aws::String& GetTaskArn() const { return m_taskArn; }
  template <typename TaskArnT = Aws::String>
  void SetTaskArn(TaskArnT&& value) {
    m_taskArnHasBeenSet = true;
    m_taskArn = std::forward<TaskArnT>(value);
  }
  template <typename TaskArnT = Aws::String>
  ExecuteCommandResult& WithTaskArn(TaskArnT&& value) {
    SetTaskArn(std::forward<TaskArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ExecuteCommandResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clusterArn;
  bool m_clusterArnHasBeenSet = false;

  Aws::String m_containerArn;
  bool m_containerArnHasBeenSet = false;

  Aws::String m_containerName;
  bool m_containerNameHasBeenSet = false;

  bool m_interactive{false};
  bool m_interactiveHasBeenSet = false;

  Session m_session;
  bool m_sessionHasBeenSet = false;

  Aws::String m_taskArn;
  bool m_taskArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECS
}  // namespace Aws
