﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/entityresolution/EntityResolution_EXPORTS.h>
#include <aws/entityresolution/model/IdNamespaceIdMappingWorkflowProperties.h>
#include <aws/entityresolution/model/IdNamespaceInputSource.h>
#include <aws/entityresolution/model/IdNamespaceType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EntityResolution {
namespace Model {
class UpdateIdNamespaceResult {
 public:
  AWS_ENTITYRESOLUTION_API UpdateIdNamespaceResult() = default;
  AWS_ENTITYRESOLUTION_API UpdateIdNamespaceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ENTITYRESOLUTION_API UpdateIdNamespaceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the ID namespace.</p>
   */
  inline const Aws::String& GetIdNamespaceName() const { return m_idNamespaceName; }
  template <typename IdNamespaceNameT = Aws::String>
  void SetIdNamespaceName(IdNamespaceNameT&& value) {
    m_idNamespaceNameHasBeenSet = true;
    m_idNamespaceName = std::forward<IdNamespaceNameT>(value);
  }
  template <typename IdNamespaceNameT = Aws::String>
  UpdateIdNamespaceResult& WithIdNamespaceName(IdNamespaceNameT&& value) {
    SetIdNamespaceName(std::forward<IdNamespaceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the ID namespace.</p>
   */
  inline const Aws::String& GetIdNamespaceArn() const { return m_idNamespaceArn; }
  template <typename IdNamespaceArnT = Aws::String>
  void SetIdNamespaceArn(IdNamespaceArnT&& value) {
    m_idNamespaceArnHasBeenSet = true;
    m_idNamespaceArn = std::forward<IdNamespaceArnT>(value);
  }
  template <typename IdNamespaceArnT = Aws::String>
  UpdateIdNamespaceResult& WithIdNamespaceArn(IdNamespaceArnT&& value) {
    SetIdNamespaceArn(std::forward<IdNamespaceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the ID namespace.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateIdNamespaceResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>InputSource</code> objects, which have the fields
   * <code>InputSourceARN</code> and <code>SchemaName</code>.</p>
   */
  inline const Aws::Vector<IdNamespaceInputSource>& GetInputSourceConfig() const { return m_inputSourceConfig; }
  template <typename InputSourceConfigT = Aws::Vector<IdNamespaceInputSource>>
  void SetInputSourceConfig(InputSourceConfigT&& value) {
    m_inputSourceConfigHasBeenSet = true;
    m_inputSourceConfig = std::forward<InputSourceConfigT>(value);
  }
  template <typename InputSourceConfigT = Aws::Vector<IdNamespaceInputSource>>
  UpdateIdNamespaceResult& WithInputSourceConfig(InputSourceConfigT&& value) {
    SetInputSourceConfig(std::forward<InputSourceConfigT>(value));
    return *this;
  }
  template <typename InputSourceConfigT = IdNamespaceInputSource>
  UpdateIdNamespaceResult& AddInputSourceConfig(InputSourceConfigT&& value) {
    m_inputSourceConfigHasBeenSet = true;
    m_inputSourceConfig.emplace_back(std::forward<InputSourceConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines the properties of <code>IdMappingWorkflow</code> where this
   * <code>IdNamespace</code> can be used as a <code>Source</code> or a
   * <code>Target</code>.</p>
   */
  inline const Aws::Vector<IdNamespaceIdMappingWorkflowProperties>& GetIdMappingWorkflowProperties() const {
    return m_idMappingWorkflowProperties;
  }
  template <typename IdMappingWorkflowPropertiesT = Aws::Vector<IdNamespaceIdMappingWorkflowProperties>>
  void SetIdMappingWorkflowProperties(IdMappingWorkflowPropertiesT&& value) {
    m_idMappingWorkflowPropertiesHasBeenSet = true;
    m_idMappingWorkflowProperties = std::forward<IdMappingWorkflowPropertiesT>(value);
  }
  template <typename IdMappingWorkflowPropertiesT = Aws::Vector<IdNamespaceIdMappingWorkflowProperties>>
  UpdateIdNamespaceResult& WithIdMappingWorkflowProperties(IdMappingWorkflowPropertiesT&& value) {
    SetIdMappingWorkflowProperties(std::forward<IdMappingWorkflowPropertiesT>(value));
    return *this;
  }
  template <typename IdMappingWorkflowPropertiesT = IdNamespaceIdMappingWorkflowProperties>
  UpdateIdNamespaceResult& AddIdMappingWorkflowProperties(IdMappingWorkflowPropertiesT&& value) {
    m_idMappingWorkflowPropertiesHasBeenSet = true;
    m_idMappingWorkflowProperties.emplace_back(std::forward<IdMappingWorkflowPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of ID namespace. There are two types: <code>SOURCE</code> and
   * <code>TARGET</code>.</p> <p>The <code>SOURCE</code> contains configurations for
   * <code>sourceId</code> data that will be processed in an ID mapping workflow.
   * </p> <p>The <code>TARGET</code> contains a configuration of
   * <code>targetId</code> to which all <code>sourceIds</code> will resolve to.</p>
   */
  inline IdNamespaceType GetType() const { return m_type; }
  inline void SetType(IdNamespaceType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline UpdateIdNamespaceResult& WithType(IdNamespaceType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
   * this role to access the resources defined in this <code>IdNamespace</code> on
   * your behalf as part of a workflow run.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  UpdateIdNamespaceResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp of when the ID namespace was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  UpdateIdNamespaceResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp of when the ID namespace was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  UpdateIdNamespaceResult& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateIdNamespaceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_idNamespaceName;
  bool m_idNamespaceNameHasBeenSet = false;

  Aws::String m_idNamespaceArn;
  bool m_idNamespaceArnHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Vector<IdNamespaceInputSource> m_inputSourceConfig;
  bool m_inputSourceConfigHasBeenSet = false;

  Aws::Vector<IdNamespaceIdMappingWorkflowProperties> m_idMappingWorkflowProperties;
  bool m_idMappingWorkflowPropertiesHasBeenSet = false;

  IdNamespaceType m_type{IdNamespaceType::NOT_SET};
  bool m_typeHasBeenSet = false;

  Aws::String m_roleArn;
  bool m_roleArnHasBeenSet = false;

  Aws::Utils::DateTime m_createdAt{};
  bool m_createdAtHasBeenSet = false;

  Aws::Utils::DateTime m_updatedAt{};
  bool m_updatedAtHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EntityResolution
}  // namespace Aws
