﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class DeregisterTargetFromMaintenanceWindowResult {
 public:
  AWS_SSM_API DeregisterTargetFromMaintenanceWindowResult() = default;
  AWS_SSM_API DeregisterTargetFromMaintenanceWindowResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API DeregisterTargetFromMaintenanceWindowResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the maintenance window the target was removed from.</p>
   */
  inline const Aws::String& GetWindowId() const { return m_windowId; }
  template <typename WindowIdT = Aws::String>
  void SetWindowId(WindowIdT&& value) {
    m_windowIdHasBeenSet = true;
    m_windowId = std::forward<WindowIdT>(value);
  }
  template <typename WindowIdT = Aws::String>
  DeregisterTargetFromMaintenanceWindowResult& WithWindowId(WindowIdT&& value) {
    SetWindowId(std::forward<WindowIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the removed target definition.</p>
   */
  inline const Aws::String& GetWindowTargetId() const { return m_windowTargetId; }
  template <typename WindowTargetIdT = Aws::String>
  void SetWindowTargetId(WindowTargetIdT&& value) {
    m_windowTargetIdHasBeenSet = true;
    m_windowTargetId = std::forward<WindowTargetIdT>(value);
  }
  template <typename WindowTargetIdT = Aws::String>
  DeregisterTargetFromMaintenanceWindowResult& WithWindowTargetId(WindowTargetIdT&& value) {
    SetWindowTargetId(std::forward<WindowTargetIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeregisterTargetFromMaintenanceWindowResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_windowId;
  bool m_windowIdHasBeenSet = false;

  Aws::String m_windowTargetId;
  bool m_windowTargetIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
