﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/states/SFN_EXPORTS.h>
#include <aws/states/model/HistoryEventExecutionDataDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SFN {
namespace Model {

/**
 * <p>Contains details about the start of the execution.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionStartedEventDetails">AWS
 * API Reference</a></p>
 */
class ExecutionStartedEventDetails {
 public:
  AWS_SFN_API ExecutionStartedEventDetails() = default;
  AWS_SFN_API ExecutionStartedEventDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SFN_API ExecutionStartedEventDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SFN_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The JSON data input to the execution. Length constraints apply to the payload
   * size, and are expressed as bytes in UTF-8 encoding.</p>
   */
  inline const Aws::String& GetInput() const { return m_input; }
  inline bool InputHasBeenSet() const { return m_inputHasBeenSet; }
  template <typename InputT = Aws::String>
  void SetInput(InputT&& value) {
    m_inputHasBeenSet = true;
    m_input = std::forward<InputT>(value);
  }
  template <typename InputT = Aws::String>
  ExecutionStartedEventDetails& WithInput(InputT&& value) {
    SetInput(std::forward<InputT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains details about the input for an execution history event.</p>
   */
  inline const HistoryEventExecutionDataDetails& GetInputDetails() const { return m_inputDetails; }
  inline bool InputDetailsHasBeenSet() const { return m_inputDetailsHasBeenSet; }
  template <typename InputDetailsT = HistoryEventExecutionDataDetails>
  void SetInputDetails(InputDetailsT&& value) {
    m_inputDetailsHasBeenSet = true;
    m_inputDetails = std::forward<InputDetailsT>(value);
  }
  template <typename InputDetailsT = HistoryEventExecutionDataDetails>
  ExecutionStartedEventDetails& WithInputDetails(InputDetailsT&& value) {
    SetInputDetails(std::forward<InputDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the IAM role used for executing Lambda
   * tasks.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  ExecutionStartedEventDetails& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies a state machine alias used for
   * starting the state machine execution.</p>
   */
  inline const Aws::String& GetStateMachineAliasArn() const { return m_stateMachineAliasArn; }
  inline bool StateMachineAliasArnHasBeenSet() const { return m_stateMachineAliasArnHasBeenSet; }
  template <typename StateMachineAliasArnT = Aws::String>
  void SetStateMachineAliasArn(StateMachineAliasArnT&& value) {
    m_stateMachineAliasArnHasBeenSet = true;
    m_stateMachineAliasArn = std::forward<StateMachineAliasArnT>(value);
  }
  template <typename StateMachineAliasArnT = Aws::String>
  ExecutionStartedEventDetails& WithStateMachineAliasArn(StateMachineAliasArnT&& value) {
    SetStateMachineAliasArn(std::forward<StateMachineAliasArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies a state machine version used
   * for starting the state machine execution.</p>
   */
  inline const Aws::String& GetStateMachineVersionArn() const { return m_stateMachineVersionArn; }
  inline bool StateMachineVersionArnHasBeenSet() const { return m_stateMachineVersionArnHasBeenSet; }
  template <typename StateMachineVersionArnT = Aws::String>
  void SetStateMachineVersionArn(StateMachineVersionArnT&& value) {
    m_stateMachineVersionArnHasBeenSet = true;
    m_stateMachineVersionArn = std::forward<StateMachineVersionArnT>(value);
  }
  template <typename StateMachineVersionArnT = Aws::String>
  ExecutionStartedEventDetails& WithStateMachineVersionArn(StateMachineVersionArnT&& value) {
    SetStateMachineVersionArn(std::forward<StateMachineVersionArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_input;
  bool m_inputHasBeenSet = false;

  HistoryEventExecutionDataDetails m_inputDetails;
  bool m_inputDetailsHasBeenSet = false;

  Aws::String m_roleArn;
  bool m_roleArnHasBeenSet = false;

  Aws::String m_stateMachineAliasArn;
  bool m_stateMachineAliasArnHasBeenSet = false;

  Aws::String m_stateMachineVersionArn;
  bool m_stateMachineVersionArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SFN
}  // namespace Aws
