﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicecatalog/ServiceCatalog_EXPORTS.h>
#include <aws/servicecatalog/model/ConstraintDetail.h>
#include <aws/servicecatalog/model/Status.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ServiceCatalog {
namespace Model {
class DescribeConstraintResult {
 public:
  AWS_SERVICECATALOG_API DescribeConstraintResult() = default;
  AWS_SERVICECATALOG_API DescribeConstraintResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SERVICECATALOG_API DescribeConstraintResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the constraint.</p>
   */
  inline const ConstraintDetail& GetConstraintDetail() const { return m_constraintDetail; }
  template <typename ConstraintDetailT = ConstraintDetail>
  void SetConstraintDetail(ConstraintDetailT&& value) {
    m_constraintDetailHasBeenSet = true;
    m_constraintDetail = std::forward<ConstraintDetailT>(value);
  }
  template <typename ConstraintDetailT = ConstraintDetail>
  DescribeConstraintResult& WithConstraintDetail(ConstraintDetailT&& value) {
    SetConstraintDetail(std::forward<ConstraintDetailT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The constraint parameters.</p>
   */
  inline const Aws::String& GetConstraintParameters() const { return m_constraintParameters; }
  template <typename ConstraintParametersT = Aws::String>
  void SetConstraintParameters(ConstraintParametersT&& value) {
    m_constraintParametersHasBeenSet = true;
    m_constraintParameters = std::forward<ConstraintParametersT>(value);
  }
  template <typename ConstraintParametersT = Aws::String>
  DescribeConstraintResult& WithConstraintParameters(ConstraintParametersT&& value) {
    SetConstraintParameters(std::forward<ConstraintParametersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the current request.</p>
   */
  inline Status GetStatus() const { return m_status; }
  inline void SetStatus(Status value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DescribeConstraintResult& WithStatus(Status value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeConstraintResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ConstraintDetail m_constraintDetail;

  Aws::String m_constraintParameters;

  Status m_status{Status::NOT_SET};

  Aws::String m_requestId;
  bool m_constraintDetailHasBeenSet = false;
  bool m_constraintParametersHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceCatalog
}  // namespace Aws
