/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class MySQLForeignKeyManager
extends SQLForeignKeyManager<MySQLTableForeignKey, MySQLTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLTableForeignKey> getObjectsCache(MySQLTableForeignKey object) {
        return ((MySQLTable)object.getParentObject()).getForeignKeyCache();
    }

    protected MySQLTableForeignKey createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, @NotNull Map<String, Object> options) {
        MySQLTable table = (MySQLTable)container;
        try {
            if ("MyISAM".equalsIgnoreCase(table.getAdditionalInfo(monitor).getEngine().getName())) {
                DBWorkbench.getPlatformUI().showError("Create foreign key", "Foreign keys are not supported by MyISAM engine.\nYou could change table's engine to INNODB or some other relational engine");
                return null;
            }
        }
        catch (DBCException e) {
            log.error((Object)e);
            return null;
        }
        MySQLTableForeignKey foreignKey = new MySQLTableForeignKey(table, "", null, (MySQLTableConstraint)this.getReferencedKey(monitor, (AbstractTable)table, MySQLTableConstraint.class, options), DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION, false);
        foreignKey.setName(this.getNewConstraintName(monitor, (AbstractTableConstraint)foreignKey));
        return foreignKey;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        this.addObjectDeleteActions(monitor, executionContext, actions, new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, (DBSObject)((MySQLTableForeignKey)command.getObject()), command.getTitle()), options);
        this.addObjectCreateActions(monitor, executionContext, actions, this.makeCreateCommand((DBSObject)((MySQLTableForeignKey)command.getObject()), options), options);
    }

    protected String getDropForeignKeyPattern(MySQLTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP FOREIGN KEY %CONSTRAINT%";
    }
}

