/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@Deprecated
public class JavaField {
    private final Field field;

    public final Field getValue() {
        return this.field;
    }

    public JavaField(Ruby runtime2, Field field) {
        this.field = field;
    }

    public final boolean equals(Object other) {
        return other instanceof JavaField && this.field.equals(((JavaField)other).field);
    }

    public final int hashCode() {
        return this.field.hashCode();
    }

    @JRubyMethod
    public RubyString value_type(ThreadContext context) {
        return Create.newString(context, this.field.getType().getName());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p(ThreadContext context) {
        return Convert.asBoolean(context, Modifier.isPublic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"static?"})
    public RubyBoolean static_p(ThreadContext context) {
        return Convert.asBoolean(context, Modifier.isStatic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"enum_constant?"})
    public RubyBoolean enum_constant_p(ThreadContext context) {
        return Convert.asBoolean(context, this.field.isEnumConstant());
    }

    @JRubyMethod
    public RubyString to_generic_string(ThreadContext context) {
        return Create.newString(context, this.field.toGenericString());
    }

    @JRubyMethod(name={"type"})
    public IRubyObject field_type(ThreadContext context) {
        return JavaClass.get(context.runtime, this.field.getType());
    }

    @JRubyMethod
    public IRubyObject value(ThreadContext context, IRubyObject object) {
        Object javaObject = !Modifier.isStatic(this.field.getModifiers()) ? this.unwrapJavaObject(context, object) : null;
        try {
            return JavaField.convertToRuby(context.runtime, this.field.get(javaObject));
        }
        catch (IllegalAccessException iae) {
            throw Error.typeError(context, "illegal access");
        }
    }

    @JRubyMethod
    public IRubyObject set_value(ThreadContext context, IRubyObject object, IRubyObject value2) {
        Object javaObject = !Modifier.isStatic(this.field.getModifiers()) ? this.unwrapJavaObject(context, object) : null;
        Object javaValue = this.convertValueToJava(value2);
        try {
            this.field.set(javaObject, javaValue);
        }
        catch (IllegalAccessException iae) {
            throw Error.typeError(context, "illegal access on setting variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw Error.typeError(context, "wrong type for " + this.field.getType().getName() + ": " + (javaValue == null ? null : javaValue.getClass().getName()));
        }
        return value2;
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p(ThreadContext context) {
        return Convert.asBoolean(context, Modifier.isFinal(this.field.getModifiers()));
    }

    @JRubyMethod
    public IRubyObject static_value(ThreadContext context) {
        try {
            return JavaField.convertToRuby(context.runtime, this.field.get(null));
        }
        catch (IllegalAccessException iae) {
            throw Error.typeError(context, "illegal static value access: " + iae.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject set_static_value(ThreadContext context, IRubyObject value2) {
        if (!(value2 instanceof JavaObject)) {
            throw Error.typeError(context, "not a java object:" + String.valueOf(value2));
        }
        Object javaValue = this.convertValueToJava(value2);
        try {
            this.field.set(null, javaValue);
        }
        catch (IllegalAccessException iae) {
            throw Error.typeError(context, "illegal access on setting static variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw Error.typeError(context, "wrong type for " + this.field.getType().getName() + ": " + (javaValue == null ? null : javaValue.getClass().getName()));
        }
        return value2;
    }

    @JRubyMethod
    public RubyString name(ThreadContext context) {
        return Create.newString(context, this.field.getName());
    }

    public AccessibleObject accessibleObject() {
        return this.field;
    }

    private Object unwrapJavaObject(ThreadContext context, IRubyObject object) throws RaiseException {
        Object javaObject = JavaUtil.unwrapJavaValue(object);
        if (javaObject == null) {
            throw Error.typeError(context, "not a java object: " + String.valueOf(object));
        }
        return javaObject;
    }

    private Object convertValueToJava(IRubyObject value2) {
        Object val = value2.dataGetStruct();
        if (val instanceof JavaObject) {
            value2 = (IRubyObject)val;
        }
        return value2.toJava(this.field.getType());
    }

    private static IRubyObject convertToRuby(Ruby runtime2, Object javaValue) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, javaValue);
    }
}

