/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class BooleanConstraint
extends Constraint {
    private final boolean b;

    public BooleanConstraint(Model model, boolean bool) {
        super("BOOLEAN", new PropBoolean(model, bool));
        this.b = bool;
    }

    @Override
    public Constraint makeOpposite() {
        return this.b ? this.propagators[0].getModel().falseConstraint() : this.propagators[0].getModel().trueConstraint();
    }

    @Explained
    public static class PropBoolean
    extends Propagator<BoolVar> {
        public final boolean bool;

        public PropBoolean(Model model, boolean bool) {
            super((Variable[])new BoolVar[]{model.boolVar(bool)});
            this.bool = bool;
        }

        @Override
        public void propagate(int evtmask) throws ContradictionException {
            if (this.bool) {
                this.setPassive();
            } else {
                this.fails(Reason.undef());
            }
        }

        @Override
        public int getPropagationConditions(int vIdx) {
            return IntEventType.all();
        }

        @Override
        public String toString() {
            return Boolean.toString(this.bool);
        }

        @Override
        public ESat isEntailed() {
            return ESat.eval(this.bool);
        }
    }
}

