/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.measure;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.search.SearchState;

public interface IMeasures
extends Serializable {
    public static final float IN_SEC = 1.0E9f;

    public String getModelName();

    public long getTimestamp();

    default public float getTimeCount() {
        return (float)this.getTimeCountInNanoSeconds() / 1.0E9f;
    }

    public long getTimeCountInNanoSeconds();

    default public float getTimeToBestSolution() {
        return (float)this.getTimeToBestSolutionInNanoSeconds() / 1.0E9f;
    }

    public long getTimeToBestSolutionInNanoSeconds();

    default public float getReadingTimeCount() {
        return (float)this.getReadingTimeCountInNanoSeconds() / 1.0E9f;
    }

    public long getReadingTimeCountInNanoSeconds();

    public long getNodeCount();

    public long getBackTrackCount();

    public long getFailCount();

    public long getFixpointCount();

    public long getPropagationCount();

    public long getBackjumpCount();

    public long getRestartCount();

    public long getSolutionCount();

    public long getDecisionCount();

    public long getMaxDepth();

    public long getCurrentDepth();

    public boolean hasObjective();

    public boolean isObjectiveOptimal();

    public Number getBestSolutionValue();

    public SearchState getSearchState();

    public IBoundsManager getBoundsManager();

    default public String toOneLineString() {
        StringBuilder st = new StringBuilder(256);
        st.append("Model[").append(this.getModelName()).append("], ");
        st.append(String.format("%d Solutions, ", this.getSolutionCount()));
        if (this.hasObjective()) {
            st.append(this.getBoundsManager()).append(", ");
        }
        st.append(String.format("Resolution time %.3fs, " + (this.hasObjective() ? String.format("Time to best solution %.3fs, ", Float.valueOf(this.getTimeToBestSolution())) : "") + "%d Nodes (%,.1f n/s), %d Backtracks, %d Backjumps, %d Fails, %d Restarts, %d Propagations", Float.valueOf(this.getTimeCount()), this.getNodeCount(), Float.valueOf((float)this.getNodeCount() / this.getTimeCount()), this.getBackTrackCount(), this.getBackjumpCount(), this.getFailCount(), this.getRestartCount(), this.getPropagationCount()));
        return st.toString();
    }

    default public String toDimacsString() {
        StringBuilder st = new StringBuilder(256);
        st.append("i ").append(this.getModelName()).append("\n");
        st.append("s ").append(this.getSearchState()).append("\n");
        if (this.hasObjective()) {
            DecimalFormat df = new DecimalFormat("#.###");
            st.append("o ").append(df.format(this.getBoundsManager().getBestSolutionValue())).append("\n");
        }
        st.append(String.format("d NBSOLS %d\nd TIME %.3f\nd NODES %d\nd BACKTRACKS %d\nd FAILURES %d\nd RESTARTS %d\nd PROPAGATIONS %d", this.getSolutionCount(), Float.valueOf(this.getTimeCount()), this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount(), this.getPropagationCount()));
        return st.toString();
    }

    default public String toMultiLineString() {
        StringBuilder st = new StringBuilder(256);
        long solutionCount = this.getSolutionCount();
        switch (this.getSearchState()) {
            case NEW: {
                st.append("- Search not started- ");
                break;
            }
            case RUNNING: {
                st.append("- Running search - ");
                break;
            }
            case TERMINATED: {
                st.append("- Complete search - ");
                if (solutionCount == 0L) {
                    st.append("No solution.");
                } else if (solutionCount == 1L) {
                    st.append("1 solution found.");
                } else {
                    st.append(String.format("%,d solution(s) found.", solutionCount));
                }
                st.append('\n');
                break;
            }
            case STOPPED: {
                st.append("- Incomplete search - Limit reached.\n");
                break;
            }
            case KILLED: {
                st.append("- Incomplete search - Unexpected interruption.\n");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal search state " + this.getSearchState());
            }
        }
        st.append("\tModel[").append(this.getModelName()).append("]\n");
        st.append(String.format("\tSolutions: %,d\n", solutionCount));
        if (this.hasObjective()) {
            st.append("\t").append(this.getBoundsManager()).append(",\n");
        }
        st.append(String.format("\tBuilding time : %,.3fs\n\tResolution time : %,.3fs\n" + (this.hasObjective() ? String.format("\tTime to best solution : %,.3fs\n", Float.valueOf(this.getTimeToBestSolution())) : "") + "\tNodes: %,d (%,.1f n/s) \n\tBacktracks: %,d\n\tBackjumps: %,d\n\tFails: %,d\n\tRestarts: %,d\n\tPropagations: %,d", Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getTimeCount()), this.getNodeCount(), Float.valueOf((float)this.getNodeCount() / this.getTimeCount()), this.getBackTrackCount(), this.getBackjumpCount(), this.getFailCount(), this.getRestartCount(), this.getPropagationCount()));
        return st.toString();
    }

    default public Number[] toArray() {
        return new Number[]{this.getSearchState().ordinal(), this.getSolutionCount(), Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getTimeCount()), this.getBoundsManager().getPolicy().ordinal(), this.hasObjective() ? (Number)this.getBestSolutionValue() : (Number)0, this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount(), this.getPropagationCount()};
    }

    default public String toCSV() {
        return String.format("%c;%d;%.3f;%.3f;%.3f;%d;%d;%d;%d;%d;%d;%d;", Character.valueOf(this.getSearchState().toString().charAt(0)), this.getSolutionCount(), Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getTimeCount()), Float.valueOf(this.getTimeToBestSolution()), this.hasObjective() ? this.getBestSolutionValue().intValue() : 0, this.getNodeCount(), this.getBackTrackCount(), this.getBackjumpCount(), this.getFailCount(), this.getRestartCount(), this.getPropagationCount());
    }
}

