/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.swapList;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class Set_Swap2
extends AbstractSet {
    protected int size = 0;
    protected TIntArrayList values;
    private final ISetIterator iter = this.newIterator();

    public Set_Swap2() {
        this.values = new TIntArrayList(4);
    }

    @Override
    public boolean add(int element) {
        if (!this.contains(element)) {
            this.values.insert(this.size, element);
            ++this.size;
            this.notifyObservingElementAdded(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element) {
        int pos = this.values.indexOf(element);
        int s = this.size();
        if (pos > -1 && pos < s) {
            this.iter.notifyRemoving(element);
            int t = this.values.get(--s);
            this.values.set(pos, t);
            this.values.set(s, element);
            --this.size;
            this.notifyObservingElementRemoved(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int element) {
        int pos = this.values.indexOf(element);
        return pos > -1 && pos < this.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.notifyObservingCleared();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        int min = this.values.get(0);
        for (int i = 1; i < this.size(); ++i) {
            if (min <= this.values.get(i)) continue;
            min = this.values.get(i);
        }
        return min;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        int max = this.values.get(0);
        for (int i = 1; i < this.size(); ++i) {
            if (max >= this.values.get(i)) continue;
            max = this.values.get(i);
        }
        return max;
    }

    @Override
    public SetType getSetType() {
        return SetType.SMALLBIPARTITESET;
    }

    @Override
    public ISetIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private int idx;

            @Override
            public void reset() {
                this.idx = 0;
            }

            @Override
            public void notifyRemoving(int item) {
                if (this.idx > 0 && item == Set_Swap2.this.values.get(this.idx - 1)) {
                    --this.idx;
                }
            }

            @Override
            public boolean hasNext() {
                return this.idx < Set_Swap2.this.size();
            }

            @Override
            public int nextInt() {
                ++this.idx;
                return Set_Swap2.this.values.get(this.idx - 1);
            }
        };
    }
}

