/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.BitSet;
import java.util.Comparator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.PropCumulative;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.sort.ArraySort;

public class PropGraphCumulative
extends PropCumulative {
    private final UndirectedGraph g;
    private final ISet tasks;
    private final ISet toCompute;
    private long timestamp;
    private boolean full;
    private final boolean fast;
    private static final int START = 1;
    private static final int END = 2;

    public PropGraphCumulative(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, boolean fast, CumulFilter ... filters) {
        super(s, d, e, h, capa, true, filters);
        this.g = new UndirectedGraph(this.model, this.n, SetType.BITSET, true);
        this.tasks = SetFactory.makeBipartiteSet(0);
        this.toCompute = SetFactory.makeBipartiteSet(0);
        this.fast = fast;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            super.propagate(evtmask);
            this.graphComputation();
        } else if (this.full) {
            this.filter(this.allTasks);
        } else {
            int count = 0;
            ISetIterator tcIt = this.toCompute.iterator();
            while (tcIt.hasNext()) {
                int i = tcIt.nextInt();
                ISetIterator it = this.g.getNeighborsOf(i).iterator();
                while (it.hasNext()) {
                    int j = it.nextInt();
                    if (!this.disjoint(i, j)) continue;
                    this.g.removeEdge(i, j);
                }
                if ((count += this.g.getNeighborsOf(i).size()) < 2 * this.n) continue;
                break;
            }
            if (count >= 2 * this.n) {
                this.filter(this.allTasks);
            } else {
                ISetIterator iter = this.toCompute.iterator();
                while (iter.hasNext()) {
                    this.filterAround(iter.nextInt());
                }
            }
        }
        this.toCompute.clear();
        this.full = false;
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (this.timestamp != (long)this.model.getEnvironment().getTimeStamp()) {
            this.timestamp = this.model.getEnvironment().getTimeStamp();
            this.toCompute.clear();
            this.full = false;
        }
        if (varIdx < 4 * this.n) {
            int v = varIdx % this.n;
            if (this.h[v].getUB() == 0 || this.d[v].getUB() == 0) {
                this.allTasks.remove(v);
                ISetIterator gIt = this.g.getNeighborsOf(v).iterator();
                while (gIt.hasNext()) {
                    this.g.removeEdge(v, gIt.nextInt());
                }
            } else if (this.s[v].getUB() < this.e[v].getLB() || !this.fast) {
                this.toCompute.add(v);
            }
        } else {
            this.updateMaxCapa();
            this.full = true;
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    protected void filterAround(int taskIndex) throws ContradictionException {
        this.tasks.clear();
        this.tasks.add(taskIndex);
        ISetIterator env = this.g.getNeighborsOf(taskIndex).iterator();
        while (env.hasNext()) {
            this.tasks.add(env.nextInt());
        }
        this.filter(this.tasks);
    }

    private boolean disjoint(int i, int j) {
        return this.s[i].getLB() >= this.e[j].getUB() || this.s[j].getLB() >= this.e[i].getUB();
    }

    private void graphComputation() {
        for (int i = 0; i < this.n; ++i) {
            this.g.getNeighborsOf(i).clear();
        }
        Event[] events = new Event[2 * this.n];
        ArraySort<Event> sort = new ArraySort<Event>(events.length, true, false);
        Comparator eventComparator = (e1, e2) -> {
            if (e1.date == e2.date) {
                return e1.type - e2.type;
            }
            return e1.date - e2.date;
        };
        BitSet tprune = new BitSet(this.n);
        for (int i = 0; i < this.n; ++i) {
            events[i] = new Event();
            events[i].set(1, i, this.s[i].getLB());
            events[i + this.n] = new Event();
            events[i + this.n].set(2, i, this.e[i].getUB());
        }
        sort.sort(events, 2 * this.n, eventComparator);
        int timeIndex = 0;
        block6: while (timeIndex < this.n * 2) {
            Event event = events[timeIndex++];
            switch (event.type) {
                case 1: {
                    boolean eok;
                    boolean bl = eok = this.h[event.index].getUB() > 0 && this.d[event.index].getUB() > 0;
                    if (eok) {
                        int i = tprune.nextSetBit(0);
                        while (i >= 0) {
                            if (this.h[i].getUB() > 0 && this.d[i].getUB() > 0) {
                                this.g.addEdge(i, event.index);
                            }
                            i = tprune.nextSetBit(i + 1);
                        }
                    }
                    tprune.set(event.index);
                    continue block6;
                }
                case 2: {
                    tprune.clear(event.index);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class Event {
        protected int type;
        protected int index;
        protected int date;

        private Event() {
        }

        protected void set(int t, int i, int d) {
            this.date = d;
            this.type = t;
            this.index = i;
        }
    }
}

