/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Scenario;

import com.conveyal.r5.shapefile.ShapefileMatcher;
import com.conveyal.r5.streets.StreetLayer;
import com.conveyal.r5.util.ShapefileReader;
import java.io.File;
import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;

public class R5RShapefileMatcher
extends ShapefileMatcher {
    public R5RShapefileMatcher(StreetLayer streets) {
        super(streets);
    }

    public void indexFeatures(String shapefileName, String attributeName) throws Throwable {
        Field fFeatureIndex = ShapefileMatcher.class.getDeclaredField("featureIndex");
        Field fAttrIndex = ShapefileMatcher.class.getDeclaredField("ltsAttributeIndex");
        fFeatureIndex.setAccessible(true);
        fAttrIndex.setAccessible(true);
        STRtree idx = new STRtree();
        try (ShapefileReader reader = new ShapefileReader(new File(shapefileName));){
            LOG.info("Indexing shapefile features");
            int attrIdx = reader.findAttribute(attributeName, Number.class);
            try (Stream stream = reader.wgs84Stream();){
                stream.forEach(feature -> {
                    LineString featureGeom = R5RShapefileMatcher.R5extractLineString(feature);
                    idx.insert(featureGeom.getEnvelopeInternal(), feature);
                });
            }
            idx.build();
            fFeatureIndex.set((Object)this, idx);
            fAttrIndex.set((Object)this, attrIdx);
        }
    }

    private static LineString R5extractLineString(SimpleFeature feature) {
        MultiLineString multiLineString = (MultiLineString)feature.getDefaultGeometry();
        if (multiLineString.getNumGeometries() != 1) {
            throw new RuntimeException("Feature does not contain a single linestring.");
        }
        return (LineString)multiLineString.getGeometryN(0);
    }
}

