## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## -----------------------------------------------------------------------------
library("Gifi")
ABC6 <- ABC[,6:11]            ## we use 6 items from the dataset
head(ABC6)

## -----------------------------------------------------------------------------
fit_ordpca <- princals(ABC6, ndim = 2, levels = "ordinal")  
fit_ordpca

## -----------------------------------------------------------------------------
summary(fit_ordpca)

## ----fig.height=5, fig.width=5------------------------------------------------
plot(fit_ordpca, plot.type = "loadplot")

## ----fig.height=5, fig.width=5------------------------------------------------
plot(fit_ordpca, plot.type = "biplot", col.loadings = "coral3", col.scores = "lightgrey")
abline(h = 0, v = 0, lty = 2)

## ----fig.height=7, fig.width=7------------------------------------------------
plot(fit_ordpca, plot.type = "transplot")

## -----------------------------------------------------------------------------
head(fit_ordpca$scoremat)

## -----------------------------------------------------------------------------
fit_metpca <- princals(ABC6, ndim = 2, levels = "metric")
fit_metpca

## ----fig.height=7, fig.width=7------------------------------------------------
plot(fit_metpca, plot.type = "transplot")

## -----------------------------------------------------------------------------
data("WilPat2")
WilPat2$Age <- cut(WilPat2$Age, breaks = c(17, 20, 23, 30, 40, 100), labels = 1:5)      
head(WilPat2)

## -----------------------------------------------------------------------------
levelvec <- c(rep("nominal", 6), "nominal", "metric", "metric", "nominal", "ordinal")    
wen_prin <- princals(WilPat2, levels = levelvec)                                          ## fit 2D princals
wen_prin
summary(wen_prin)

## ----fig.height=7, fig.width=7------------------------------------------------
plot(wen_prin, plot.type = "transplot", var.subset = c(1, 8, 9, 11))

## ----fig.height=7, fig.width=7------------------------------------------------
plot(wen_prin, plot.type = "jointplot", expand = 0.08)                 

## ----fig.height=7, fig.width=7------------------------------------------------
plot(wen_prin, "objplot", cex.scores = 0.6)                 

