/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;

class SelectedSparseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseObjectMatrix1D(int n, AbstractLongObjectMap abstractLongObjectMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongObjectMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected SelectedSparseObjectMatrix1D(AbstractLongObjectMap abstractLongObjectMap, int[] nArray) {
        this(nArray.length, abstractLongObjectMap, 0, 1, nArray, 0);
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public Object getQuick(int n) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + n * this.stride]);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedSparseObjectMatrix1D) {
            SelectedSparseObjectMatrix1D selectedSparseObjectMatrix1D = (SelectedSparseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedSparseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof SparseObjectMatrix1D) {
            SparseObjectMatrix1D sparseObjectMatrix1D = (SparseObjectMatrix1D)objectMatrix1D;
            return this.elements == sparseObjectMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
    }

    public ObjectMatrix1D like(int n) {
        return new SparseObjectMatrix1D(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public ObjectMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, Object object) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (object == null) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, object);
        }
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseObjectMatrix1D(this.elements, nArray);
    }
}

