/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.RankedForest;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NewickImporter;
import jebl.evolution.trees.RootedTree;

public class RankedNode {
    int rank;
    int n;
    RankedNode child1;
    RankedNode child2;
    BitSet cladeBits;
    static BitSet inter = new BitSet();
    static long[] Rn;
    static int max;

    public RankedNode(int n, int n2) {
        this.rank = n - n2;
        this.n = n2;
        this.child1 = null;
        this.child2 = null;
        this.cladeBits = new BitSet(n2);
        this.cladeBits.set(n);
    }

    public RankedNode(int n, RankedNode rankedNode, RankedNode rankedNode2) {
        this.rank = n;
        this.n = rankedNode.n;
        if (rankedNode.cladeBits.intersects(rankedNode2.cladeBits)) {
            throw new IllegalArgumentException();
        }
        this.cladeBits = new BitSet();
        this.cladeBits.or(rankedNode.cladeBits);
        this.cladeBits.or(rankedNode2.cladeBits);
        this.child1 = rankedNode;
        this.child2 = rankedNode2;
    }

    public boolean compatible(BitSet bitSet) {
        if (this.cladeBits.intersects(bitSet)) {
            inter.clear();
            inter.or(this.cladeBits);
            inter.and(bitSet);
            return inter.cardinality() == Math.min(this.cladeBits.cardinality(), bitSet.cardinality());
        }
        return true;
    }

    public boolean isExternal() {
        return this.child1 == null && this.child2 == null;
    }

    public RankedNode[] getChildren() {
        if (this.isExternal()) {
            return new RankedNode[0];
        }
        return new RankedNode[]{this.child1, this.child2};
    }

    public RootedTree getTree() {
        try {
            NewickImporter newickImporter = new NewickImporter(new StringReader(this.toNewick()), true);
            return (RootedTree)newickImporter.importNextTree();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toNewick() {
        return this.toNewick(this, null);
    }

    private String toNewick(RankedNode rankedNode, RankedNode rankedNode2) {
        if (rankedNode.isExternal()) {
            return (char)(rankedNode.rank + rankedNode.n + 65) + ":" + (rankedNode2.rank + 1);
        }
        if (rankedNode.child1.compare(rankedNode.child2) > 0) {
            RankedNode rankedNode3 = rankedNode.child1;
            rankedNode.child1 = rankedNode.child2;
            rankedNode.child2 = rankedNode3;
        }
        return "(" + this.toNewick(rankedNode.child1, rankedNode) + ", " + this.toNewick(rankedNode.child2, rankedNode) + "):" + (rankedNode2 != null ? rankedNode2.rank - rankedNode.rank : 0);
    }

    private int compare(RankedNode rankedNode) {
        if (this.isExternal()) {
            if (rankedNode.isExternal()) {
                return this.rank - rankedNode.rank;
            }
            return 1 - rankedNode.cladeBits.cardinality();
        }
        return this.cladeBits.cardinality() - rankedNode.cladeBits.cardinality();
    }

    public static void main(String[] stringArray) throws IOException, ImportException {
        String[] stringArray2 = new String[]{"111110000", "111111110"};
        int n = stringArray2[0].length();
        Rn = new long[12];
        RankedNode.Rn[0] = 1L;
        RankedNode.Rn[1] = 1L;
        for (int i = 2; i < Rn.length; ++i) {
            RankedNode.Rn[i] = Rn[i - 1] * (long)((i + 1) * i / 2);
            System.out.println(i + 1 + "\t" + Rn[i]);
        }
        RankedForest.Default default_ = new RankedForest.Default(n, false);
        ArrayList<RankedNode> arrayList = new ArrayList<RankedNode>();
        ArrayList<BitSet> arrayList2 = new ArrayList<BitSet>();
        for (String l2 : stringArray2) {
            arrayList2.add(default_.getNodes().get(0).createClade(l2));
        }
        int[] nArray = new int[]{0, 0};
        long l = System.currentTimeMillis();
        RankedNode.processHistory(default_, arrayList, arrayList2, nArray);
        long l2 = System.currentTimeMillis();
        System.out.println("n = " + n);
        System.out.println("Constraints:");
        for (BitSet bitSet : arrayList2) {
            System.out.println("  " + bitSet);
        }
        int n2 = arrayList.size() + nArray[1];
        System.out.println(n2 + " histories found in " + nArray[0] + " calls");
        System.out.println("Took " + (double)Math.round((double)(l2 - l) / 10.0) / 100.0 + " seconds");
        System.out.println("Max size of clear forest: " + max);
    }

    private BitSet createClade(String string) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '1') continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private static void processHistory(RankedForest rankedForest, List<RankedNode> list, List<BitSet> list2, int[] nArray) {
        nArray[0] = nArray[0] + 1;
        List<RankedNode> list3 = rankedForest.getNodes();
        int n = list3.size();
        if (n == 1) {
            nArray[1] = nArray[1] + 1;
            if (nArray[0] % 10000000 == 0) {
                System.out.println(nArray[1]);
            }
        } else if (rankedForest.isClear()) {
            int n2 = rankedForest.getNodes().size();
            if (n2 > max) {
                max = n2;
            }
            nArray[1] = (int)((long)nArray[1] + Rn[n2 - 1]);
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    Object object;
                    RankedNode rankedNode = new RankedNode(rankedForest.rank() + 1, list3.get(i), list3.get(j));
                    boolean bl = true;
                    if (list2 != null) {
                        object = list2.iterator();
                        while (object.hasNext()) {
                            BitSet bitSet = object.next();
                            if (rankedNode.compatible(bitSet)) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (!bl || !(object = new RankedForest.Parent(rankedForest, rankedNode, list2)).compatibleRank(list2)) continue;
                    RankedNode.processHistory((RankedForest)object, list, list2, nArray);
                }
            }
        }
    }

    static {
        max = 1;
    }
}

