/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.util.Units;
import dr.evomodel.coalescent.PopulationSizeFunction;
import dr.evomodel.coalescent.PopulationSizeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.List;

public class PiecewisePopulationSizeModel
extends PopulationSizeModel {
    private final List<PopulationSizeModel> epochs;
    private final Parameter epochDurations;
    private PopulationSizeFunction populationSizeFunction = null;
    private boolean updateEpochs = true;

    public PiecewisePopulationSizeModel(Parameter parameter, List<PopulationSizeModel> list, Parameter parameter2, Units.Type type) {
        this("", parameter, list, parameter2, type);
    }

    public PiecewisePopulationSizeModel(String string, Parameter parameter, List<PopulationSizeModel> list, Parameter parameter2, Units.Type type) {
        super(string, parameter, type);
        if (parameter2.getDimension() != list.size() - 1) {
            throw new IllegalArgumentException("The number of epoch durations should be one fewer than the number of epochs");
        }
        this.epochs = new ArrayList<PopulationSizeModel>();
        for (PopulationSizeModel populationSizeModel : list) {
            this.addModel(populationSizeModel);
            this.epochs.add(populationSizeModel);
        }
        this.epochDurations = parameter2;
        this.addVariable(this.epochDurations);
        this.addStatistic(new TransitionTimesStatistic());
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
        this.updateEpochs = true;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
        this.updateEpochs = true;
    }

    private void setupEpochs() {
        if (this.updateEpochs) {
            double d = this.epochDurations.getParameterValue(0);
            double d2 = this.epochs.get(0).getPopulationSizeFunction().getLogDemographic(d);
            for (int i = 1; i < this.epochs.size(); ++i) {
                this.epochs.get(i).setLogN0(d2);
                d2 = this.epochs.get(i).getPopulationSizeFunction().getLogDemographic(d);
            }
            this.updateEpochs = false;
        }
    }

    @Override
    public PopulationSizeFunction getPopulationSizeFunction() {
        if (this.populationSizeFunction == null) {
            this.populationSizeFunction = new PopulationSizeFunction(){

                @Override
                public double getLogDemographic(double d) {
                    int n;
                    PiecewisePopulationSizeModel.this.setupEpochs();
                    double d2 = d;
                    for (n = 0; n < PiecewisePopulationSizeModel.this.epochDurations.getDimension() && d > PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n); ++n) {
                        d2 -= PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n);
                    }
                    return ((PopulationSizeModel)PiecewisePopulationSizeModel.this.epochs.get(n)).getPopulationSizeFunction().getLogDemographic(d2);
                }

                @Override
                public double getIntegral(double d, double d2) {
                    int n;
                    PiecewisePopulationSizeModel.this.setupEpochs();
                    double d3 = 0.0;
                    double d4 = d;
                    double d5 = d2;
                    for (n = 0; n < PiecewisePopulationSizeModel.this.epochDurations.getDimension() && d4 > PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n); d4 -= PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n), ++n) {
                    }
                    while (n < PiecewisePopulationSizeModel.this.epochDurations.getDimension() && d5 > PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n)) {
                        d3 += ((PopulationSizeModel)PiecewisePopulationSizeModel.this.epochs.get(n)).getPopulationSizeFunction().getIntegral(d4, PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n));
                        d4 = 0.0;
                        d5 -= PiecewisePopulationSizeModel.this.epochDurations.getParameterValue(n);
                        ++n;
                    }
                    return d3 += ((PopulationSizeModel)PiecewisePopulationSizeModel.this.epochs.get(n)).getPopulationSizeFunction().getIntegral(d4, d5);
                }

                @Override
                public Units.Type getUnits() {
                    return PiecewisePopulationSizeModel.this.getUnits();
                }

                @Override
                public void setUnits(Units.Type type) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.populationSizeFunction;
    }

    public class TransitionTimesStatistic
    extends Statistic.Abstract {
        public TransitionTimesStatistic() {
            super("transitionTimes");
        }

        @Override
        public int getDimension() {
            return PiecewisePopulationSizeModel.this.epochDurations.getDimension();
        }

        @Override
        public double getStatisticValue(int n) {
            double d = 0.0;
            for (int i = 0; i <= n; ++i) {
                d += PiecewisePopulationSizeModel.this.epochDurations.getStatisticValue(i);
            }
            return d;
        }
    }
}

