/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class PrintListener
implements ActionListener {
    private DviFile m_Source;
    private int m_DefaultDoubleSide = 0;
    private int m_PrintOption = 16;
    private int m_PaperSize = 70;

    public PrintListener(DviFile dviFile) {
        this.m_Source = dviFile;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.getResourceString("print.Current.label"))) {
            this.m_PrintOption = 16;
        } else if (string.equals(this.getResourceString("print.FtoB.label"))) {
            this.m_PrintOption = 17;
        } else if (string.equals(this.getResourceString("print.BtoF.label"))) {
            this.m_PrintOption = 18;
        } else {
            if (string.equals(this.getResourceString("print.Double.label"))) {
                PrintDoubleSided printDoubleSided = new PrintDoubleSided(this.m_Source, this.getResourceString("print.Double.label"));
                printDoubleSided.setLocationRelativeTo(this.m_Source.getContentPane());
                printDoubleSided.pack();
                ((Component)printDoubleSided).setVisible(true);
                return;
            }
            System.out.println("Print Listener: " + string);
            return;
        }
        this.m_Source.getPage().setPrintOption(this.m_PrintOption);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob.printDialog()) {
            PageFormat pageFormat = printerJob.defaultPage();
            pageFormat.setOrientation(this.m_Source.getPaperOrient());
            Dimension dimension = this.m_Source.getPaperSize();
            Paper paper = pageFormat.getPaper();
            paper.setSize(dimension.getWidth(), dimension.getHeight());
            paper.setImageableArea(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
            pageFormat.setPaper(paper);
            printerJob.setPrintable(this.m_Source.getPage(), pageFormat);
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("PrintListener e=" + printerException.getMessage());
                printerException.printStackTrace();
            }
        } else {
            this.m_Source.getLog().append("User aborted Print.\n");
        }
    }

    private String getResourceString(String string) {
        this.m_Source.getSource();
        String string2 = DviMain.getResourceString(string);
        return string2;
    }
}

