$!
$! File: FLoad.com
$!       This VMS command file implements partial downloading
$!       of the ATM compatible PostScript Type 1 fonts which 
$!       is used in specified PostScript file.
$!       This procedure is done via GhostScript & SubFont programs.
$!
$! Copyright (C) 1994, Basil K. Malyshev. All rights reserved.
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Customize this variables...
$ gs="$usr_local:[exe]gs.exe"
$ define/nolog   gs_path usr_local:[lib.gs]
$ define/nolog font_path disk$et:[tex.newtex.xps],disk$et:[tex.newtex.ps]
$! SubFont must be defined erlier ...
$! subfont=="$disk$et:[texmgr.bkm.fload.src]subfont.exe"
$! Which font set is in printer
$ fontSet="Standard"
$! 
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ cf = F$ENV("PROCEDURE")
$ root=f$parse(cf,,,"DEVICE") + f$parse(cf,,,"DIRECTORY")
$ define/nolog fload_lib 'root'
$ define/nolog fload_path fload_lib,font_path,gs_path
$!
$ echo="write sys$output"
$!
$! Recompute map on switch '-updatemap'
$ if ( P1 .eqs. "-updatemap" .or. P1 .eqs. "-UPDATEMAP" )
$ then
$   open/write  lun fontmap.t1
$   write       lun " "
$   close       lun
$   list_loop:
$     tmp = f$sear("font_path:*.*")
$     if tmp .eqs. "" then goto list_end
$     type = f$par(tmp,,,"TYPE")
$     if ( type .eqs. ".PFB" .or. type .eqs. ".PFA" )
$     then
$        fname=f$par(tmp,,,"NAME") + type
$        write sys$output "Process " + tmp
$        subfont -zFontmap.t1 font_path:'fname'
$     endif
$     goto list_loop
$   list_end:
$   exit
$ endif
$!
$! Check all required arguments is in command line 
$ if ( P1 .eqs. "-P" ) 
$ then
$    if ( P2 .eqs. "" ) 
$    then 
$       echo "There are following font sets:"
$       direct_dcl fload_lib:*.FS
$       exit
$    endif
$    fontSet=P2
$    ifn=P3
$    out=P4
$ else
$    ifn=P1
$    out=P2
$ endif
$ if ( f$sear("fload_lib:"+fontSet+".FS") .eqs. "" ) 
$ then
$   echo "? "+fontSet+" font set is not known."
$   exit
$ endif
$! If input file name is not presented show usage and list of built in fonts.
$ if "''ifn'" .eqs. "" .or. "''out'" .eqs. "" 
$ then
   $ echo "Usage: (of the fload de Basil/VMS version)"
   $ echo "fload [-p <fontset>] <input-ps-file> <output-ps-file>"
   $ exit
$ endif
$! Check file existance, and make full file name 
$ fn = f$search(ifn)
$ if fn .eqs. "" 
$ then
   $ echo "? FLoad: Can not found file "+ifn
   $ exit
$ endif

$! Interpret file via Ghostscript to determine required fonts and characters.
$!fbase=f$parse(fn,,,"DEVICE")+f$parse(fn,,,"DIRECTORY")+f$parse(fn,,,"NAME")
$ fbase=f$parse(out,,,"DEVICE")+f$parse(out,,,"DIRECTORY")+f$parse(out,,,"NAME")
$ out=fbase+f$parse(out,,,"TYPE")
$ if out .eqs. fbase+"." then $ out=fbase+".ps"
$ fstat=fbase+".fstat"
$ echo "Process PS file "+fn+"." 
$ echo "Write font using statistic to "+fstat
$ if f$search(fstat) .nes. "" then $ delete_command/nolog 'fstat';*
$ define/user gs_lib fload_path:
$ define/user sys$output 'fbase'.flog
$ gs "-DNODISPLAY" "-DWRITESYSTEMDICT" "-sOUTFILE=''fstat'" -
  "-sRESIDENTFONTS=''fontSet'.FS" "-sINFILE=''fn'" psfstat.ps
$ if f$search(fstat) .eqs. "" 
$ then
  $ echo "? FLOAD EROOR: There is some errors in scanning PS file." 
  $ echo "!   Look GhostScript log file "+fbase+".flog for more information"
  $ echo "!   Most frequently error is that some font is not anywhere."
  $ exit
$ else
$ delete_dcl/nolog 'fbase'.flog;
$ delete_dcl/nolog 'fstat';-1
$ endif

$ echo "Writing main output PS file: "+out
$ open/write outfd 'out' 
$ write      outfd "%!PS-Adobe-3.0"
$ close      outfd
$! Make partial downloading of these fonts which is available
$ if f$search(fbase+".undef") .nes. "" then $ delete_cmd/nolog 'fbase'.undef;*
$ subfont -I,FONT_PATH: -u'fbase'.undef -mFLOAD_LIB:Fontmap.t1 -a'out' -f'fstat' -c 'fn'
$ if f$search(fbase+".undef") .nes. "" 
$ then 
   $ echo "There is fonts which is not found by SubFont program."
   $ echo "That is fonts:"
   $ type_dcl 'fbase'.undef
   $ echo "This list is also saved in file "+fbase+".undef"
$ endif
$ exit
