@echo off

rem makeafm: generate .afm file from PostScript type 1 font file
rem	     (faking character bounding box information)
rem	It accepts the file formats:
rem	.pfb - type 1 encrypted binary file

rem This script uses:
rem 1. To disassemble the type 1 font (.pfb file):
rem    the program t1disasm from the package t1utils posted by 
rem    I. Lee Hetherington with the following modification to t1disasm.c:
rem	look up the line   output(" {\n");
rem	at the beginning of the routine do_charstring and remove the \n .
rem 2. To extract pair kerning information from .pfm files:
rem	a) either the program pfm2afm
rem	b) or the program dumppfm (version 1.5.3)

set dumvar=
set dumvar2=
if not "%1"=="-" goto normal
set del=rem
shift
:normal
if not exist %1.pfb goto error

rem first, extract all information we need into a separate file since the 
rem source file is very long and we need to scan its information several times
if exist %1.ps$ goto ext
if exist %1.ps goto ps
echo extracting information from %1.pfb
D:\fonts\progs\t1utils\t1disasm %1.pfb > %TEMP%\%1.ps
sed -e "y/	/ /" %TEMP%\%1.ps > %TEMP%\%1.pb$
%del% del %TEMP%\%1.ps
goto pb
:ps
sed -e "y/	/ /" %1.ps > %TEMP%\%1.pb$
:pb
egrep -e "(^ */.*def|^/[A-z0-9]* *[<{].*sbw|^[- 0-9]*seac)" %TEMP%\%1.pb$ > %1.ps$
%del% del %TEMP%\%1.pb$
:ext

rem try to save kerning information from previous .afm file or to extract 
rem it from .pfm file
if exist %1.afm goto afmkern
if not exist %1.pfm goto startafm
echo extracting kerning and height information from %1.pfm
pfm2afm %1
rem dumppfm %1.pfm %1.afm
if not exist %1.inf call afm-inf %1
:afmkern
echo saving kerning and height information from %1.afm
egrep -e "^(StartKern|EndKern|KPX)" %1.afm > %TEMP%\%1.kpx
egrep -e "^(CapHeight|XHeight|Ascender|Descender)" %1.afm > %TEMP%\%1.hei

:startafm
echo making %1.afm
echo StartFontMetrics 1.0 > %1.afm
echo Comment generated from Type 1 font >> %1.afm
rem generate fixed Encoding specification (mind!)
echo EncodingScheme AdobeStandardEncoding >> %1.afm
rem extract font information items and transform into afm syntax
sed -f D:\fonts\progs\makeafm\fontinf1.sed %1.ps$ > %TEMP%\%1.fi
sed -f D:\fonts\progs\makeafm\fontinf2.sed %TEMP%\%1.fi >> %1.afm
%del% del %TEMP%\%1.fi
rem determine if the ligatures fi and fl are present
sed -e "s,^/f\([il]\) .*,set fifl=%%fifl%% L \1 f\1 ;," -e tx -e d -e :x %1.ps$ > %TEMP%\%1.bat
sed -f D:\fonts\progs\makeafm\fontbbox.sed %1.afm >> %TEMP%\%1.bat
if not exist %TEMP%\%1.hei goto nohei
rem type %TEMP%\%1.hei >> %1.afm
egrep -v CapHeight %TEMP%\%1.hei >> %1.afm
sed -e "s,^\([^ ][^ ]*\) *\([-0-9]*\) *$,set \1=\2," %TEMP%\%1.hei >> %TEMP%\%1.bat
%del% del %TEMP%\%1.hei
:nohei
set fifl=
call %TEMP%\%1.bat
echo CapHeight %CapHeight% >> %1.afm
set BBoxC= B %llx% %Descender% %urx% %CapHeight% ;
set BBoxX= B %llx% %Descender% %urx% %XHeight% ;
set BBox= B %llx% %Descender% %urx% %Ascender% ;
%del% del %TEMP%\%1.bat

rem now extract the metrics information
rem echo StartCharMetrics >> %1.afm
sed -f D:\fonts\progs\makeafm\fontmetr.sed %1.ps$ > %TEMP%\%1.ex
egrep -c -e . %TEMP%\%1.ex | sed -e "s,^,StartCharMetrics " >> %1.afm
echo s,\( N *f .*\)$,\1%BBox%%fifl%,> %TEMP%\%1.sed
echo s,\( N *[A-Z][^;]*;\),\1%BBoxC%,>> %TEMP%\%1.sed
rem echo s,\( N *[acegm-su-z][^;]*;\),\1%BBoxX%,>> %TEMP%\%1.sed
echo s,\( N *x[^;]*;\),\1%BBoxX%,>> %TEMP%\%1.sed
echo tx>> %TEMP%\%1.sed
echo s,\( N [^;]*;\),\1%BBox%,>> %TEMP%\%1.sed
echo tx>> %TEMP%\%1.sed
echo d>> %TEMP%\%1.sed
echo :x>> %TEMP%\%1.sed
sed -f %TEMP%\%1.sed %TEMP%\%1.ex >> %1.afm
%del% del %TEMP%\%1.ex
%del% del %TEMP%\%1.sed
echo EndCharMetrics >> %1.afm

rem insert previously extracted or saved kerning information
if not exist %TEMP%\%1.kpx goto nokern
rem type %TEMP%\%1.kpx >> %1.afm
egrep -e "^StartKern" %TEMP%\%1.kpx >> %1.afm
egrep -e "^KPX" %TEMP%\%1.kpx | sort >> %1.afm
egrep -e "^EndKern" %TEMP%\%1.kpx >> %1.afm
:nokern

goto nocompo
rem finally, extract composite character information as available
echo StartComposites >> %1.afm
rem since we will only find character encodings (as index into 
rem StandardEncoding), we have to translate them into their names:
sed -f D:\fonts\progs\makeafm\PCCinfo.sed %1.ps$ > %TEMP%\%1.pcc
sed -f D:\fonts\progs\makeafm\PCCnames.sed %TEMP%\%1.pcc >> %1.afm
%del% del %TEMP%\%1.pcc
rem The accent shift values (substituted as \1 and \2 above) 
rem are not exact. The difference of the "side bearing points" 
rem (letter - accent) would have to be added to it.
echo EndComposites >> %1.afm
:nocompo
rem and finish the job
echo EndFontMetrics >> %1.afm
%del% del %1.ps$
if exist %TEMP%\%1.kpx %del% del %TEMP%\%1.kpx
goto end

:error
echo makeafm failed
:end
