---
myst:
  html_meta:
    keywords: LaTeX, fichiers, postscript, type 3, pkfix
---

# Comment replacer des fontes de Type 3 dans un document PostScript ?

Vous pouvez parfois rencontrer des fichiers PostScript générés par `dvips` et
contenant des fontes PK. En générant un PDF à partir d'un tel fichier, 
la qualité est médiocre.

Bien sûr, la bonne solution est de régénérer le fichier PostScript, 
mais si vous ne disposez ni des sources ni du fichier DVI, 
il faut recourir à une sorte de correctif pour remplacer 
les polices bitmap du fichier par des polices de contour.

Le programme `pkfix` (par Heiko Oberdiek) effectue ce remplacement, 
pour les fichiers créés par des versions "pas trop anciennes" de `dvips` : 
il trouve les polices à remplacer en examinant les commentaires PostScript 
que `dvips` a mis dans le fichier. Pour chaque police, 
`pkfix` met les commandes TeX appropriées dans un fichier, 
qu'il traite ensuite et exécute à travers `dvips` (avec le commutateur `-Ppdf`)
pour obtenir une copie appropriée de la police. 
Ces copies sont ensuite replacées dans le fichier original.

Si votre fichier source est plus ancien que ce que `pkfix` peut traiter, 
il y a encore un peu d'espoir : `pkfix-helper` examine les polices bitmap du document,
les compare avec les polices métriques (`tfm`) de votre système 
et détermine une proposition sur la police qui pourrait être la bonne. 
Le programme signale les "mauvaises correspondances" 
et propose des options pour confirmer ou remplacer ses recommandations. 
La technique (qui semble pourtant peu plausible) est suffisamment efficace 
pour mériter un essai.

Une autre option est le logiciel (shareware) de Frank Siegert,
[PStill](http://www.pstill.com), capable d'éditer le PostScript qu'il traite, 
et une de ses options consiste à remplacer les polices bitmap du fichier 
par des versions de type 1.


:::{sources}
[Replacing Type 3 fonts in PostScript](faquk:FAQ-pkfix)
:::