/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import java.io.IOException;

public class AtRoman
extends Command {
    private byte state;
    public static final byte UPPER = 0;
    public static final byte LOWER = 1;

    public AtRoman(String string, byte by) {
        super(string);
        if (by != 0 && by != 1) {
            throw new IllegalArgumentException(String.format("Invalid state '%d' for AtRoman ", by));
        }
        this.state = by;
    }

    @Override
    public Object clone() {
        return new AtRoman(this.getName(), this.state);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.getSymbol(teXParser, teXParser.popNumber());
        if (teXObject instanceof TeXObjectList) {
            return (TeXObjectList)teXObject;
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXObject);
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.getSymbol(teXParser, teXObjectList.popNumber(teXParser));
        if (teXObject instanceof TeXObjectList) {
            return (TeXObjectList)teXObject;
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        teXObjectList2.add(teXObject);
        return teXObjectList2;
    }

    protected TeXObject getSymbol(TeXParser teXParser, TeXNumber teXNumber) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        String string = RomanNumeral.romannumeral(teXNumber.number(teXParser));
        return teXParser.getListener().createString(this.state == 0 ? string.toUpperCase() : string);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.getSymbol(teXParser, teXParser.popNumber());
        teXObject.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.getSymbol(teXParser, teXObjectList.popNumber(teXParser));
        teXObject.process(teXParser, teXObjectList);
    }
}

