/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.L2HGlsStyleTree;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;

public class TreeGlossEntry
extends AbstractGlsCommand {
    protected L2HGlsStyleTree treeStyle;

    public TreeGlossEntry(L2HGlsStyleTree l2HGlsStyleTree) {
        this("glossentry", l2HGlsStyleTree);
    }

    public TreeGlossEntry(String string, L2HGlsStyleTree l2HGlsStyleTree) {
        super(string, l2HGlsStyleTree.getGlossariesSty());
        this.treeStyle = l2HGlsStyleTree;
    }

    @Override
    public Object clone() {
        return new TreeGlossEntry(this.getName(), this.treeStyle);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        IntegerContentCommand integerContentCommand = this.treeStyle.getLevelCommand();
        TokenListCommand tokenListCommand = this.treeStyle.getPendingCommand();
        TeXParserUtils.process(tokenListCommand.getContent(), teXParser, teXObjectList);
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            TeXParserListener teXParserListener = teXParser.getListener();
            TeXObjectList teXObjectList2 = teXParserListener.createStack();
            teXObjectList2.add(new StartElement("dt"));
            teXObjectList2.add(teXParserListener.getControlSequence("glsentryitem"));
            teXObjectList2.add(glsLabel);
            teXObjectList2.add(teXParserListener.getControlSequence("glstreenamefmt"));
            Group group = teXParserListener.createGroup();
            teXObjectList2.add(group);
            group.add(teXParserListener.getControlSequence("glstarget"));
            group.add(glsLabel);
            group.add(TeXParserUtils.createGroup(teXParserListener, teXParserListener.getControlSequence("glossentryname"), glsLabel));
            teXObjectList2.add(new EndElement("dt"));
            teXObjectList2.add(new StartElement("dd"));
            if (glossaryEntry.hasField("symbol")) {
                teXObjectList2.add(teXParserListener.getControlSequence("space"));
                teXObjectList2.add(teXParserListener.getOther(40));
                teXObjectList2.add(teXParserListener.getControlSequence("glossentrysymbol"));
                teXObjectList2.add(glsLabel);
                teXObjectList2.add(teXParserListener.getOther(41));
            }
            teXObjectList2.add(teXParserListener.getControlSequence("glstreepredesc"));
            teXObjectList2.add(teXParserListener.getControlSequence("glossentrydesc"));
            teXObjectList2.add(glsLabel);
            teXObjectList2.add(teXParserListener.getControlSequence("glspostdescription"));
            teXObjectList2.add(teXParserListener.getControlSequence("space"));
            teXObjectList2.add(teXObject);
            tokenListCommand.append(new EndElement("dd"));
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        }
        integerContentCommand.setValue(0);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

