unit pretprn;
{  Printer subroutines for PrET

11 Feb 91 JCC  Corrections to EPSON
11 Oct 90 JCC  \perp
 4 Sep 90 JCC  Corrections: map characters for graphics.
30,31 Aug 90 JCC  IBM.
?? Aug 90 JCC  Graphics instead of downloadable font.
 7 Jun 90 JCC

   Available printers:

      EPSON: Debugged on and equivalent to Panasonic 1092i
      P1180/P1092: Panasonic 1092i and 1180
      IBM:   IBM Proprinter.  Frac not supported.
      MPI:   MPI Sprinter; not completely supported.
      DUMB:  For any printer, specials printed in ASCII.
      TTY:   For any printer, specials not printed.

}
{$I etdirect.inc}            {Directives shared by all units}

interface

uses utils, pretdef;

const
   MAXPR = 10;
   NumPr: integer = 7;
   LegalPrName: array[1..MAXPR] of String[32]=
       ('EPSON', 'MPI', 'P1180', 'P1092', 'DUMB', 'TTY', 'IBM', '', '', '');
   IBMFont: FontPtr = nil;
   EpsFont: FontPtr = nil;

procedure ListPrs (var f: text);
function  GoodPrName (PrName: LongString): boolean;
procedure SetPrinter (var MyState: state; PrName: LongString);
procedure SetEpsonPrinter (var MyState: state);
procedure EpsonVDo (var f: text; V : integer);
procedure SetIBMPrinter (var MyState: state);
procedure IBMVDo (var f: text; V : integer);
procedure SetMPIPrinter (var MyState: state);
procedure MPIVDo (var f: text; V : integer);
procedure SetDumbPrinter (var MyState: state);
procedure DumbVDo (var f: text; V : integer);
procedure SetTTYPrinter (var MyState: state);

implementation (* ============ IMPLEMENTATION ============== *)

procedure DefaultGreek (var MyState: state);
   { Assumes begin and end greek set.
     GreekMap[c] is translation of ^g+c in nongraphics mode.
     GreekMapGr[c] is #0 if GreekMap[c] is to be used in graphics mode,
     else it flags character to be used in graphics font.}
   var c: char;
   begin { GreekMap[c] defaults to BeginGreek+c+EndGreek }
      with MyState do begin
         ThisGraphDef  := false;
         GraphSwitchPoss:= false;
         GreekGraphics := false;
         GreekGrLen:= 0;
         GreekGrIntro:= '';
         GreekGrFont:= nil;
         for c := #0 to #255 do begin
            GreekMap[c] := BeginGreek + c + EndGreek;
            GreekMapGr[c] := c;
         end;
      end;
   end;

procedure StandardOverrides (var MyState: state);
  begin
   with MyState do begin
      GreekMap['^'] := BeginGreek + ':' + EndGreek;
      GreekMap['_'] := BeginGreek + ';' + EndGreek;
      GreekMap['O'] := BeginGreek + 'W' + EndGreek;
      GreekMap['o'] := BeginGreek + 'w' + EndGreek;
      GreekMap['h'] := BeginGreek + 'y' + EndGreek;
      GreekMap['Z'] := BeginGreek + 'v' + EndGreek;
      GreekMap['V'] := BeginGreek + 'H' + EndGreek;
      GreekMap['N'] := BeginGreek + 'V' + EndGreek;
      GreekMap['v'] := BeginGreek + 'h' + EndGreek;
      GreekMap['('] := '<';   { \langle }
      GreekMap[')'] := '>';   { \rangle }
      GreekMap['T'] := '|'#8'_';    { \perp }

      GreekMapGr['^'] := ':';
      GreekMapGr['_'] := ';';
      GreekMapGr['O'] := 'W';
      GreekMapGr['o'] := 'w';
      GreekMapGr['h'] := 'y';
      GreekMapGr['Z'] := 'v';
      GreekMapGr['V'] := 'H';
      GreekMapGr['N'] := 'V';
      GreekMapGr['v'] := 'h';
      GreekMapGr['('] := #0;   { \langle }
      GreekMapGr[')'] := #0;   { \rangle }
      GreekMapGr['T'] := #0;   { \perp }
   end;
  end;

procedure ListPrs (var f: text);
var i: integer;
begin
   for i := 1 to NumPr do begin
      write (f, LegalPrName[i]);
      if i = NumPr then
         writeln (f)
      else
         write (f, ', ');
   end;
end;

function  GoodPrName (PrName: LongString): boolean;
var i: integer;
begin
   UC (PrName);
   rtb (PrName);
   GoodPrName := false;
   for i := 1 to NumPr do
      if (PrName = LegalPrName[i]) and (PrName <> '') then GoodPrName := true;
end;

procedure SetPrinter (var MyState: state; PrName: LongString);
begin
   UC (PrName);
   rtb (PrName);
   if (PrName = 'EPSON') or (PrName = 'P1092') or (PrName = 'P1180') then
      SetEpsonPrinter (MyState)
   else if PrName = 'IBM' then
      SetIBMPrinter (MyState)
   else if PrName = 'MPI' then
      SetMPIPrinter (MyState)
   else if PrName = 'DUMB' then
      SetDumbPrinter (MyState)
   else if PrName = 'TTY' then
      SetTTYPrinter (MyState)
   else begin
      writeln ('I cannot initialize printer ''', PrName, '''.');
      SetDumbPrinter (MyState);
   end;
   with MyState do
     if GraphSwitchPoss then
       case UseGraph of
         GrDef: GreekGraphics := ThisGraphDef;
         GrYes: GreekGraphics := true;
         GrNo:  GreekGraphics := false;
       end;
end;

procedure SetDumbPrinter (var MyState: state);
begin
   with Mystate do begin
      Printer   := 'DUMB';
      PrtVDo    := DumbVDo;
      MaxVMoveDots := 1;
      PrtVDPI   := 6;
      NoRevLF   := true;
      BeginSup  := '\u3';
      EndSup    := '\d3';
      BeginSub  := '\d3';
      EndSub    := '\u3';
      BeginGreek:= '\f1';
      EndGreek  := '\f0';
      BeginBold := '';
      EndBold   := '';
      BeginULine:= '';
      EndULine  := '';
      SetWide   := '';
      SetNar    := '';
      SetLM0    := '';
      BeginItal := '';
      EndItal   := '';
      cpi10     := '';
      cpi12     := '';
      beginfrac := '(';
      midfrac   := ') / (';
      endfrac   := ')';
      PrtSignOn := '';
      PrtSignOff:= '';
   end;
   DefaultGreek (MyState);
end;


{$F+}
procedure DumbVDo (var f: text; V : integer);
var i: integer;
begin
   for i := 1 to V do writeln (f);
end;

{$F-}

procedure SetTTYPrinter (var MyState: state);
begin
   with Mystate do begin
      Printer   := 'TTY';
      PrtVDo    := DumbVDo;
      MaxVMoveDots := 1;
      PrtVDPI   := 6;
      NoRevLF   := true;
      BeginSup  := '';
      EndSup    := '';
      BeginSub  := '';
      EndSub    := '';
      BeginGreek:= '';
      EndGreek  := '';
      BeginBold := '';
      EndBold   := '';
      BeginULine:= '';
      EndULine  := '';
      SetWide   := '';
      SetNar    := '';
      SetLM0    := '';
      BeginItal := '';
      EndItal   := '';
      cpi10     := '';
      cpi12     := '';
      beginfrac := '';
      midfrac   := '';
      endfrac   := '';
      PrtSignOn := '';
      PrtSignOff:= '';
   end;
   DefaultGreek (MyState);
end;

{$F+}
procedure EpsGrkDraft; external;
{$L epsgrdr}


procedure SetEpsonPrinter (var MyState: state);
begin
   with Mystate do begin
      Printer   := 'Panasonic KX-P/Epson FX-80';
      PrtVDo    := EpsonVDo;
      MaxVMoveDots := 255;
      PrtVDPI   := 216;
      NoRevLF   := false;
      BeginSup  := esc + 'j' + chr(PrtVDPI div 12);
      EndSup    := esc + 'J' + chr(PrtVDPI div 12);
      BeginSub  := EndSup;
      EndSub    := BeginSup;
      BeginBold := esc + 'E';
      EndBold   := esc + 'F';
      BeginULine:= esc + '-' + CHR(1);
      EndULine  := esc + '-' + CHR(0);
      SetWide   := esc + 'W' + CHR(1);
      SetNar    := esc + 'W' + CHR(0);
      SetLM0    := esc + 'l' + CHR(0);
      BeginItal := esc + '4';
      EndItal   := esc + '5';
      cpi10     := #18 + esc + 'P';
      cpi12     := #18 + esc + 'M';
      beginfrac := '';
      midfrac   := '';
      endfrac   := '';
      BeginGreek:= esc + '%' + CHR(1) + CHR(0);
      EndGreek  := esc + '%' + CHR(0) + CHR(0);
      DefaultGreek (MyState);
      ThisGraphDef := true;
      GraphSwitchPoss:= true;
      GreekGraphics := ThisGraphDef;
      GreekGrLen:= 24;
      GreekGrIntro:= esc+'^'#7#12#0;
      GreekGrFont:= EpsFont;
      PrtSignOn := EndGreek + EndULine + SetNar + SetLM0 + EndItal + cpi12;
      PrtSignOff:= PrtSignOn;
   end;
   StandardOverrides (MyState);
end;


{$F+}
procedure EpsonVDo (var f: text; V : integer);
   { Move in printer units.  }
   var VMove: integer;
       s: string [4];
   begin
      if V > 0 then
         s := esc+'J'
      else begin
         s := esc+'j';
         V := -V;
      end;
      while V > 0 do begin
         VMove := V;
         if VMove > 255 then VMove := 255;
         write (f, s + chr(VMove));
         V := V - VMove;
      end;
   end;

{$F-}

procedure SetIBMPrinter (var MyState: state);
  var i, j: integer;
begin
   with Mystate do begin
      Printer   := 'IBM Proprinter -- no fractions';
      PrtVDo    := IBMVDo;
      MaxVMoveDots := 255;
      PrtVDPI   := 216;
      NoRevLF   := true;
      BeginSup  := esc + 'S'#0;
      EndSup    := esc + 'T';
      BeginSub  := esc + 'S'#1;
      EndSub    := esc + 'T';
      BeginBold := esc + 'E';
      EndBold   := esc + 'F';
      BeginULine:= esc + '-' + CHR(1);
      EndULine  := esc + '-' + CHR(0);
      SetWide   := esc + 'W' + CHR(1);
      SetNar    := esc + 'W' + CHR(0);
      SetLM0    := esc + 'X'#1#96;
      BeginItal := '';
      EndItal   := '';
      cpi10     := #18;
      cpi12     := esc + ':';
      beginfrac := '\frac {';
      midfrac   := '}{';
      endfrac   := '}';
      BeginGreek:= esc + 'I'#4;
      EndGreek  := esc + 'I'#0;
      DefaultGreek (MyState);
      ThisGraphDef := true;
      GraphSwitchPoss := true;
      GreekGraphics := ThisGraphDef;
      GreekGrLen:= 12;
      GreekGrIntro:= esc+'Y'#12#0;
      if IBMFont = nil then begin
         new (IBMFont);
         for i := 1 to 96 do
           for j := 1 to 12 do
              IBMFont^[i][j] := EpsFont^[i][j*2-1];
      end;
      GreekGrFont:= IBMFont;
      PrtSignOn := EndGreek + EndULine + SetNar + EndItal + cpi12 + SetLM0;
      PrtSignOff:= PrtSignOn;
   end;
   StandardOverrides (MyState);
end;


{$F+}
procedure IBMVDo (var f: text; V : integer);
   { Move in printer units.  }
   var VMove: integer;
       s: string [4];
   begin
      if V > 0 then
         s := esc+'J'
      else begin
(*         s := esc+'j';
         V := -V;
*)
      end;
      while V > 0 do begin
         VMove := V;
         if VMove > 255 then VMove := 255;
         write (f, s + chr(VMove));
         V := V - VMove;
      end;
   end;




procedure SetMPIPrinter (var MyState: state);
  var i, j: integer;
begin
   with Mystate do begin
      Printer   := 'MPI Sprinter -- no fractions, sub-superscripts';
      PrtVDo    := MPIVDo;
      MaxVMoveDots := 15;
      PrtVDPI   := 72;
      NoRevLF   := true;
      BeginSup  := '';
      EndSup    := '';
      BeginSub  := '';
      EndSub    := '';
      BeginGreek:= esc + 'B';
      EndGreek  := esc + 'C';
      BeginBold := '';
      EndBold   := '';
      BeginULine:= #14;
      EndULine  := #15;
      SetWide   := esc + 'N';
      SetNar    := esc + 'O';
      SetLM0    := esc + 'L0.';
      BeginItal := '';
      EndItal   := '';
      cpi10     := esc + '\';
      cpi12     := esc + ']';
      beginfrac := '';
      midfrac   := '';
      endfrac   := '';
      PrtSignOn := EndGreek + EndULine + EndBold + SetNar + SetLM0;
      PrtSignOn := PrtSignOn + EndItal + cpi12;
      PrtSignOff:= PrtSignOn;
   end;
   DefaultGreek (MyState);
   StandardOverrides (MyState);
end;


{$F+}
procedure MPIVDo (var f: text; V : integer);
(* Move in printer units.  *)
var VMove: integer;
begin
   while V > 0 do begin
      VMove := V;
      if VMove > 15 then VMove := 15;
      write (f, esc+'W'+chr(ord('0')+VMove));
      V := V - VMove;
   end;
end;

{$F-}


begin (* ================== INITIALIZATION ================= *)
   EpsFont := @EpsGrkDraft;
end.

