/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.SeekableInputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.BlockInfo;
import org.tukaani.xz.index.IndexBase;

public class IndexDecoder
extends IndexBase {
    private final StreamFlags streamFlags;
    private final long streamPadding;
    private final int memoryUsage;
    private final long[] unpadded;
    private final long[] uncompressed;
    private long largestBlockSize = 0L;
    private int recordOffset = 0;
    private long compressedOffset = 0L;
    private long uncompressedOffset = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexDecoder(SeekableInputStream seekableInputStream, StreamFlags streamFlags, long l, int n) throws IOException {
        super(new CorruptedInputException("XZ Index is corrupt"));
        int n2;
        this.streamFlags = streamFlags;
        this.streamPadding = l;
        long l2 = seekableInputStream.position() + streamFlags.backwardSize - 4L;
        CRC32 cRC32 = new CRC32();
        CheckedInputStream checkedInputStream = new CheckedInputStream(seekableInputStream, cRC32);
        if (checkedInputStream.read() != 0) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        try {
            long l3 = DecoderUtil.decodeVLI(checkedInputStream);
            if (l3 >= streamFlags.backwardSize / 2L) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (l3 > Integer.MAX_VALUE) {
                throw new UnsupportedOptionsException("XZ Index has over 2147483647 Records");
            }
            this.memoryUsage = 1 + (int)((16L * l3 + 1023L) / 1024L);
            if (n >= 0 && this.memoryUsage > n) {
                throw new MemoryLimitException(this.memoryUsage, n);
            }
            this.unpadded = new long[(int)l3];
            this.uncompressed = new long[(int)l3];
            int n3 = 0;
            for (n2 = (int)l3; n2 > 0; --n2) {
                long l4 = DecoderUtil.decodeVLI(checkedInputStream);
                long l5 = DecoderUtil.decodeVLI(checkedInputStream);
                if (seekableInputStream.position() > l2) {
                    throw new CorruptedInputException("XZ Index is corrupt");
                }
                this.unpadded[n3] = this.blocksSum + l4;
                this.uncompressed[n3] = this.uncompressedSum + l5;
                super.add(l4, l5);
                if (!$assertionsDisabled && (long)(++n3) != this.recordCount) {
                    throw new AssertionError();
                }
                if (this.largestBlockSize >= l5) continue;
                this.largestBlockSize = l5;
            }
        }
        catch (EOFException eOFException) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        int n4 = this.getIndexPaddingSize();
        if (seekableInputStream.position() + (long)n4 != l2) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        while (n4-- > 0) {
            if (checkedInputStream.read() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        long l6 = cRC32.getValue();
        for (n2 = 0; n2 < 4; ++n2) {
            if ((l6 >>> n2 * 8 & 0xFFL) == (long)seekableInputStream.read()) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
    }

    public void setOffsets(IndexDecoder indexDecoder) {
        this.recordOffset = indexDecoder.recordOffset + (int)indexDecoder.recordCount;
        this.compressedOffset = indexDecoder.compressedOffset + indexDecoder.getStreamSize() + indexDecoder.streamPadding;
        if (!$assertionsDisabled && (this.compressedOffset & 3L) != 0L) {
            throw new AssertionError();
        }
        this.uncompressedOffset = indexDecoder.uncompressedOffset + indexDecoder.uncompressedSum;
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public StreamFlags getStreamFlags() {
        return this.streamFlags;
    }

    public int getRecordCount() {
        return (int)this.recordCount;
    }

    public long getUncompressedSize() {
        return this.uncompressedSum;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public boolean hasUncompressedOffset(long l) {
        return l >= this.uncompressedOffset && l < this.uncompressedOffset + this.uncompressedSum;
    }

    public boolean hasRecord(int n) {
        return n >= this.recordOffset && (long)n < (long)this.recordOffset + this.recordCount;
    }

    public void locateBlock(BlockInfo blockInfo, long l) {
        if (!$assertionsDisabled && l < this.uncompressedOffset) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (l -= this.uncompressedOffset) >= this.uncompressedSum) {
            throw new AssertionError();
        }
        int n = 0;
        int n2 = this.unpadded.length - 1;
        while (n < n2) {
            int n3 = n + (n2 - n) / 2;
            if (this.uncompressed[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        this.setBlockInfo(blockInfo, this.recordOffset + n);
    }

    public void setBlockInfo(BlockInfo blockInfo, int n) {
        if (!$assertionsDisabled && n < this.recordOffset) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (long)(n - this.recordOffset) >= this.recordCount) {
            throw new AssertionError();
        }
        blockInfo.index = this;
        blockInfo.blockNumber = n;
        int n2 = n - this.recordOffset;
        if (n2 == 0) {
            blockInfo.compressedOffset = 0L;
            blockInfo.uncompressedOffset = 0L;
        } else {
            blockInfo.compressedOffset = this.unpadded[n2 - 1] + 3L & 0xFFFFFFFFFFFFFFFCL;
            blockInfo.uncompressedOffset = this.uncompressed[n2 - 1];
        }
        blockInfo.unpaddedSize = this.unpadded[n2] - blockInfo.compressedOffset;
        blockInfo.uncompressedSize = this.uncompressed[n2] - blockInfo.uncompressedOffset;
        blockInfo.compressedOffset += this.compressedOffset + 12L;
        blockInfo.uncompressedOffset += this.uncompressedOffset;
    }

    static {
        $assertionsDisabled = !IndexDecoder.class.desiredAssertionStatus();
    }
}

