---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Use of GET request method with sensitive query strings (Authorization header details)

## Description

The authorization header value was identified in the request URL. These headers typically contain
usernames and passwords or JWT tokens. These values should never be sent in GET requests as they
maybe captured by proxy systems, stored in browser history, or stored in log files. If an attacker
were to get access to these logs or logging systems, they would be able to gain access to the
target account.

## Remediation

Authorization header details should never be sent in GET requests. When transmitting sensitive information
such as JWT tokens, always use `POST` requests or headers to transmit the sensitive data.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 598.3 | true | 598 | Passive | Medium |

## Links

- [OWASP](https://owasp.org/www-community/vulnerabilities/Information_exposure_through_query_strings_in_url)
- [CWE](https://cwe.mitre.org/data/definitions/598.html)
