/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw3d.AbstractRouter3D;
import org.eclipse.draw3d.Connection3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Transformable;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometryext.PointList3D;
import org.eclipse.draw3d.util.Draw3DCache;

public interface ConnectionRouter3D
extends ConnectionRouter {
    public static final ConnectionRouter3D NULL = new NullConnectionRouter3D();

    public static class NullConnectionRouter3D
    extends AbstractRouter3D {
        NullConnectionRouter3D() {
        }

        public void route(Connection connection) {
            if (connection instanceof Connection3D) {
                Vector3f tmp = Draw3DCache.getVector3f();
                try {
                    Connection3D c3D = (Connection3D)connection;
                    PointList3D points = c3D.getPoints3D();
                    points.removeAllPoints();
                    this.getStartPoint3D(c3D, tmp);
                    c3D.transformToAbsolute((Transformable)tmp);
                    points.add((IVector3f)tmp);
                    this.getEndPoint3D(c3D, tmp);
                    c3D.transformToAbsolute((Transformable)tmp);
                    points.add((IVector3f)tmp);
                    c3D.setPoints3D(points);
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
                    throw throwable;
                }
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{tmp});
            } else {
                PointList points = connection.getPoints();
                points.removeAllPoints();
                Point p = this.getStartPoint(connection);
                connection.translateToRelative((Translatable)p);
                points.addPoint(p);
                p = this.getEndPoint(connection);
                connection.translateToRelative((Translatable)p);
                points.addPoint(p);
                connection.setPoints(points);
            }
        }
    }
}

