/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.lang.reflect.Constructor;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.features.IFeatureContainer;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;

public class FeatureContainerDescriptor
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "featureContainer";
    protected String type;
    protected String containerClassName;

    public FeatureContainerDescriptor(IConfigurationElement e) {
        super(e);
        this.type = e.getAttribute("type");
        this.containerClassName = e.getAttribute("class");
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Class getType() {
        ClassLoader cl = this.getRuntime().getRuntimeExtension().getClass().getClassLoader();
        try {
            return Class.forName(this.type, true, cl);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IFeatureContainer getFeatureContainer() {
        try {
            ClassLoader cl = this.getRuntime().getRuntimeExtension().getClass().getClassLoader();
            Constructor<?> ctor = null;
            Class<?> adapterClass = Class.forName(this.containerClassName, true, cl);
            ctor = adapterClass.getConstructor(new Class[0]);
            return (IFeatureContainer)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Activator.logError(e);
            return null;
        }
    }
}

