/******************************************************************************* 
 * Copyright (c) 2011, 2012 Red Hat, Inc. 
 *  All rights reserved. 
 * This program is made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Red Hat, Inc. - initial API and implementation 
 *
 * @author Innar Made
 ******************************************************************************/
package org.eclipse.bpmn2.modeler.ui.features.gateway;

import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.MoveFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.AppendActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.event.AppendEventFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;

public abstract class AbstractGatewayFeatureContainer extends BaseElementFeatureContainer {
	
	@Override
	public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
		return new UpdateAbstractGatewayFeature(fp);
	}

	@Override
	public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
		return null;
	}

	@Override
	public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
		return new MoveFlowNodeFeature(fp);
	}

	@Override
	public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
		return new DefaultResizeShapeFeature(fp) {
			@Override
			public boolean canResizeShape(IResizeShapeContext context) {
				return false;
			}
		};
	}

	@Override
	public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
		return new AbstractDefaultDeleteFeature(fp);
	}

	@Override
	public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
		ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
		ICustomFeature[] thisFeatures = new ICustomFeature[4 + superFeatures.length];
		int i;
		for (i=0; i<superFeatures.length; ++i)
			thisFeatures[i] = superFeatures[i];
		thisFeatures[i++] = new AppendActivityFeature(fp);
		thisFeatures[i++] = new AppendGatewayFeature(fp);
		thisFeatures[i++] = new AppendEventFeature(fp);
		thisFeatures[i++] = new MorphGatewayFeature(fp);
		return thisFeatures;
	}

	private class UpdateAbstractGatewayFeature extends UpdateLabelFeature {

		public UpdateAbstractGatewayFeature(IFeatureProvider fp) {
			super(fp);
		}

		@Override
		public boolean canUpdate(IUpdateContext context) {
			IFeatureProvider featureProvider = getFeatureProvider();

			if (context.getPictogramElement() instanceof ContainerShape) {
				ContainerShape gatewayShape = (ContainerShape) context.getPictogramElement();
			for (Anchor anchor : gatewayShape.getAnchors()) {
				for (Connection connection : anchor.getIncomingConnections() ) {
					IUpdateContext updateCtx = new UpdateContext(connection);
					IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateCtx);
					if (updateFeature != null) {
						boolean ret = updateFeature.canUpdate(updateCtx);
						if (ret)
							return ret;
					}
				}
				for (Connection connection : anchor.getOutgoingConnections() ) {
					IUpdateContext updateCtx = new UpdateContext(connection);
					IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateCtx);
					if (updateFeature != null) {
						boolean ret = updateFeature.canUpdate(updateCtx);
						if (ret)
							return ret;
					}
				}
			}
			}			
			return super.canUpdate(context);
		}

		@Override
		public IReason updateNeeded(IUpdateContext context) {
			IReason reason = super.updateNeeded(context);
			if (reason.toBoolean())
				return reason;

			IFeatureProvider featureProvider = getFeatureProvider();

			if (context.getPictogramElement() instanceof ContainerShape) {
				ContainerShape gatewayShape = (ContainerShape) context.getPictogramElement();
			for (Anchor anchor : gatewayShape.getAnchors()) {
				for (Connection connection : anchor.getIncomingConnections() ) {
					IUpdateContext updateCtx = new UpdateContext(connection);
					IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateCtx);
					if (updateFeature != null) {
						IReason ret = updateFeature.updateNeeded(updateCtx);
						if (ret.toBoolean())
							return ret;
					}
				}
				for (Connection connection : anchor.getOutgoingConnections() ) {
					IUpdateContext updateCtx = new UpdateContext(connection);
					IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateCtx);
					if (updateFeature != null) {
						IReason ret = updateFeature.updateNeeded(updateCtx);
						if (ret.toBoolean())
							return ret;
					}
				}
			}
			}			
			return super.updateNeeded(context);
		}

		@Override
		public boolean update(IUpdateContext context) {
			IFeatureProvider featureProvider = getFeatureProvider();

			if (context.getPictogramElement() instanceof ContainerShape) {
			ContainerShape gatewayShape = (ContainerShape) context.getPictogramElement();
			for (Anchor anchor : gatewayShape.getAnchors()) {
				for (Connection connection : anchor.getIncomingConnections() ) {
					IUpdateContext updateCtx = new UpdateContext(connection);
					IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateCtx);
					if (updateFeature != null) {
						updateFeature.update(updateCtx);
					}
				}
				for (Connection connection : anchor.getOutgoingConnections() ) {
					IUpdateContext updateCtx = new UpdateContext(connection);
					IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateCtx);
					if (updateFeature != null) {
						updateFeature.update(updateCtx);
						}
					}
				}
			}
			return super.update(context);
		}
	}
}