/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Option implements Enumerator
{
    INCLUDE_REQUIRED(0, "INCLUDE_REQUIRED", "requirements"),
    INCLUDE_ALL_ENVIRONMENTS(1, "INCLUDE_ALL_ENVIRONMENTS", "allEnvironments"),
    INCLUDE_SOURCE(2, "INCLUDE_SOURCE", "source"),
    INCLUDE_CONFIGURE_PHASE(3, "INCLUDE_CONFIGURE_PHASE", "configurePhase");

    public static final int INCLUDE_REQUIRED_VALUE = 0;
    public static final int INCLUDE_ALL_ENVIRONMENTS_VALUE = 1;
    public static final int INCLUDE_SOURCE_VALUE = 2;
    public static final int INCLUDE_CONFIGURE_PHASE_VALUE = 3;
    private static final Option[] VALUES_ARRAY;
    public static final List<Option> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Option[]{INCLUDE_REQUIRED, INCLUDE_ALL_ENVIRONMENTS, INCLUDE_SOURCE, INCLUDE_CONFIGURE_PHASE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Option get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Option result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Option getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Option result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Option get(int value) {
        switch (value) {
            case 0: {
                return INCLUDE_REQUIRED;
            }
            case 1: {
                return INCLUDE_ALL_ENVIRONMENTS;
            }
            case 2: {
                return INCLUDE_SOURCE;
            }
            case 3: {
                return INCLUDE_CONFIGURE_PHASE;
            }
        }
        return null;
    }

    private Option(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

