/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class WorkbenchUtility {
    public static final String SQL_BUILDER_ID = "org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderEditor";
    public static final String SQL_EDITOR_ID = "org.eclipse.datatools.sqltools.sqleditor";
    public static final String QUERY_EXTENSION = "sql";
    public static final String QUERY_DDL_EXTENSION = "ddl";

    public static IEditorPart getActiveEditor() {
        IWorkbench workbench = SQLBuilderPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    public static IFile getSQLFileResource(String projectName, String resourceName) {
        IFile stmtFile = null;
        Path stmtPath = WorkbenchUtility.getSQLResourcePath(projectName, resourceName);
        stmtFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)stmtPath);
        return stmtFile;
    }

    public static Path getSQLResourcePath(String projectName, String resourceName) {
        String stmtPathStr = String.valueOf(File.separatorChar) + projectName + File.separatorChar + resourceName;
        String stmtPathExt = "";
        int dotIndex = stmtPathStr.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < stmtPathStr.length() - 1) {
            stmtPathExt = stmtPathStr.substring(dotIndex + 1);
        }
        if (!stmtPathExt.equalsIgnoreCase(QUERY_EXTENSION) && !stmtPathExt.equalsIgnoreCase(QUERY_DDL_EXTENSION)) {
            stmtPathStr = String.valueOf(stmtPathStr) + "." + QUERY_EXTENSION;
        }
        Path stmtPath = new Path(stmtPathStr);
        return stmtPath;
    }

    public static List getSelectStatementsFromProject(IProject project, SQLDomainModel domainModel) {
        ArrayList<IFile> selectStmtList = new ArrayList<IFile>();
        String dbProduct = null;
        String dbVersion = null;
        SQLQueryParserManager parserManager = null;
        if (project != null) {
            IResource[] resources = WorkbenchUtility.getSQLStatements(project);
            String fileContent = "";
            DatabaseDefinition dbdef = domainModel.getDatabaseDefinition();
            if (dbdef != null) {
                dbProduct = domainModel.getDatabaseDefinition().getProduct();
                dbVersion = domainModel.getDatabaseDefinition().getVersion();
            }
            parserManager = SQLQueryParserManagerProvider.getInstance().getParserManager(dbProduct, dbVersion);
            int i = 0;
            while (i < resources.length) {
                boolean contains = false;
                IFile file = (IFile)resources[i];
                contains = selectStmtList.contains(file);
                if (!contains) {
                    try {
                        fileContent = "";
                        fileContent = WorkbenchUtility.readFileContentsToString(file, false).trim();
                    }
                    catch (Exception exception) {}
                    QueryStatement parsedStatement = null;
                    try {
                        parsedStatement = parserManager.checkSyntax(fileContent);
                    }
                    catch (SQLParserException sQLParserException) {
                    }
                    catch (SQLParserInternalException sQLParserInternalException) {}
                    if (parsedStatement instanceof QuerySelectStatement) {
                        selectStmtList.add(file);
                    }
                }
                ++i;
            }
        }
        return selectStmtList;
    }

    public static IResource[] getSQLStatements(IProject aProj) {
        ArrayList<IResource> sqlStmts = new ArrayList<IResource>();
        try {
            IResource[] all = aProj.members();
            int i = 0;
            while (i < all.length) {
                String ext = all[i].getFileExtension();
                if (QUERY_EXTENSION.equalsIgnoreCase(ext) || QUERY_DDL_EXTENSION.equalsIgnoreCase(ext)) {
                    sqlStmts.add(all[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return sqlStmts.toArray(new IResource[sqlStmts.size()]);
    }

    public static void openEditor(final IEditorInput editorInput, final String editorId) {
        if (editorInput != null) {
            IWorkbench workbench = SQLBuilderPlugin.getPlugin().getWorkbench();
            final IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        workbenchWindow.getActivePage().openEditor(editorInput, editorId);
                    }
                    catch (PartInitException ex) {
                        SQLBuilderPlugin.getPlugin().getLogger().writeLog("Exception encountered when attempting to open editor: " + editorInput + "\n\n" + (Object)((Object)ex));
                    }
                }
            });
        }
    }

    public static void openEditor(IFile fileResource) {
        WorkbenchUtility.openEditor(fileResource, SQL_BUILDER_ID);
    }

    public static void openEditor(IFile fileResource, String editorID) {
        if (fileResource != null) {
            FileEditorInput editorInput = new FileEditorInput(fileResource);
            WorkbenchUtility.openEditor((IEditorInput)editorInput, editorID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileContentsToString(IFile fileResource, boolean includeNewlines) {
        StringBuffer strBuf = new StringBuffer();
        InputStream iStream = null;
        try {
            iStream = fileResource.getContents();
            String encoding = fileResource.getCharset();
            if (iStream != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(iStream, encoding));
                String tmpStr = "";
                while (tmpStr != null) {
                    tmpStr = in.readLine();
                    if (tmpStr == null) continue;
                    strBuf.append(tmpStr);
                    if (includeNewlines) {
                        strBuf.append(System.getProperty("line.separator"));
                        continue;
                    }
                    strBuf.append(" ");
                }
            }
        }
        catch (CoreException e) {
            SQLBuilderPlugin.getPlugin().getLogger().writeLog(e.getMessage());
            if (iStream == null) return strBuf.toString();
            try {
                iStream.close();
                return strBuf.toString();
            }
            catch (IOException iOException) {}
            return strBuf.toString();
        }
        catch (IOException e) {
            try {
                SQLBuilderPlugin.getPlugin().getLogger().writeLog(e.getMessage());
                if (iStream == null) return strBuf.toString();
            }
            catch (Throwable throwable) {
                if (iStream == null) throw throwable;
                try {
                    iStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                iStream.close();
                return strBuf.toString();
            }
            catch (IOException iOException) {}
            return strBuf.toString();
        }
        if (iStream == null) return strBuf.toString();
        try {
            iStream.close();
            return strBuf.toString();
        }
        catch (IOException iOException) {}
        return strBuf.toString();
    }

    public static boolean refreshLocalWorkspaceFile(IFile fileResource, IProgressMonitor progressMonitor) {
        if (fileResource != null) {
            try {
                fileResource.refreshLocal(1, progressMonitor);
                return true;
            }
            catch (CoreException e) {
                SQLBuilderPlugin.getPlugin().getLogger().writeLog(e.getMessage());
            }
        }
        return false;
    }

    public static IFile saveStatementAsSQLFileResource(QueryStatement statement, String projectName) {
        String statementName = statement.getName();
        String statementContent = statement.getSQL();
        return WorkbenchUtility.saveTextAsSQLFileResource(statementContent, statementName, projectName);
    }

    public static IFile saveTextAsSQLFileResource(String content, String resourceName, String projectName) {
        IFile fileResource = WorkbenchUtility.getSQLFileResource(projectName, resourceName);
        WorkbenchUtility.saveStringAsFileResource(fileResource, content);
        return fileResource;
    }

    public static void saveStringAsFileResource(IFile fileResource, String content) {
        block19: {
            ByteArrayInputStream iStream;
            block18: {
                iStream = null;
                try {
                    try {
                        String encoding = ResourcesPlugin.getEncoding();
                        if (fileResource.exists()) {
                            try {
                                iStream = new ByteArrayInputStream(content.getBytes(encoding));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                iStream = new ByteArrayInputStream(content.getBytes());
                            }
                            fileResource.setContents((InputStream)iStream, true, false, null);
                            break block18;
                        }
                        File file = fileResource.getLocation().toFile();
                        if (file.exists()) break block18;
                        try {
                            iStream = new ByteArrayInputStream(content.getBytes(encoding));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            iStream = new ByteArrayInputStream(content.getBytes());
                        }
                        fileResource.create((InputStream)iStream, false, null);
                        fileResource.setCharset(encoding, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {
                        fileResource = null;
                        if (iStream != null) {
                            try {
                                iStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (iStream != null) {
                        try {
                            iStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
            }
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int[] getSegments(int offset, String text) {
        if (text == null || text.equals("")) {
            return null;
        }
        boolean found = true;
        int searchIndex = 0;
        ArrayList<Integer> segmentList = new ArrayList<Integer>();
        segmentList.add(new Integer(0));
        while (found) {
            int index = text.indexOf(34, searchIndex);
            if (index == -1) {
                found = false;
            }
            if (index <= 0) continue;
            segmentList.add(new Integer(index));
            searchIndex = index + 1;
        }
        int[] temp = new int[segmentList.size()];
        int i = 0;
        while (i < segmentList.size()) {
            temp[i] = (Integer)segmentList.get(i);
            ++i;
        }
        return temp;
    }
}

