/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class DropListViewer
extends StructuredViewer {
    private Combo mCombo;
    private List listMap = new ArrayList();

    public DropListViewer(Composite parent, int style) {
        this.mCombo = new Combo(parent, style | 8);
        this.hookControl((Control)this.mCombo);
    }

    public DropListViewer(Composite parent) {
        this(parent, 2052);
    }

    public Combo getCombo() {
        return this.mCombo;
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && element.equals(this.getRoot())) {
            return this.getCombo();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element != null && this.listMap.contains(element)) {
            return this.getCombo();
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        int ix;
        if (element != null && (ix = this.listMap.indexOf(element)) >= 0) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            this.mCombo.setItem(ix, labelProvider.getText(element));
        }
    }

    protected List getSelectionFromWidget() {
        Object o;
        int index = this.getCombo().getSelectionIndex();
        ArrayList list = new ArrayList();
        if (index >= 0 && (o = this.listMap.get(index)) != null) {
            list.add(o);
        }
        return list;
    }

    protected void internalRefresh(Object element) {
        if (element == null || element.equals(this.getRoot())) {
            Combo combo = this.getCombo();
            Object[] children = this.getSortedChildren(this.getRoot());
            String[] labels = new String[children.length];
            List selection = this.getSelectionFromWidget();
            combo.setRedraw(false);
            this.listMap.clear();
            combo.removeAll();
            this.unmapAllElements();
            int index = 0;
            int count = children.length;
            while (index < count) {
                Object o = children[index];
                labels[index] = ((ILabelProvider)this.getLabelProvider()).getText(o);
                this.listMap.add(o);
                this.mapElement(o, (Widget)combo);
                ++index;
            }
            combo.setItems(labels);
            combo.setRedraw(true);
            this.setSelectionToWidget(selection, false);
        } else {
            this.doUpdateItem((Widget)this.getCombo(), element, true);
        }
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        Combo combo = this.getCombo();
        if (l == null || l.size() == 0) {
            combo.clearSelection();
        } else {
            combo.select(this.listMap.indexOf(l.get(0)));
        }
    }

    public Control getControl() {
        return this.mCombo;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.internalRefresh(this.getRoot());
        this.setSelectionToWidget(null, false);
        super.inputChanged(input, oldInput);
    }
}

