/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.ParametersRowData;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseRoutine;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.sqltools.common.core.tableviewer.AbstractTableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableDataChangeListener;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.emf.common.util.EList;

public class ParametersData
extends AbstractTableData {
    public static HashMap INOUT_MAPPING = new HashMap();
    public static HashMap TSQL_INOUT_MAPPING;
    private static final String[] COLUMN_NAMES;
    public static final int[] COLUMN_LENGTH;
    public static final int DIRTY_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int INOUT_COLUMN = 3;
    public static final int DEFAULT_COLUMN = 4;
    private boolean _tsql = true;

    static {
        INOUT_MAPPING.put("", ParameterMode.IN_LITERAL);
        INOUT_MAPPING.put("IN", ParameterMode.IN_LITERAL);
        INOUT_MAPPING.put("OUT", ParameterMode.OUT_LITERAL);
        INOUT_MAPPING.put("INOUT", ParameterMode.INOUT_LITERAL);
        TSQL_INOUT_MAPPING = new HashMap();
        TSQL_INOUT_MAPPING.put("", ParameterMode.IN_LITERAL);
        TSQL_INOUT_MAPPING.put("IN", ParameterMode.IN_LITERAL);
        TSQL_INOUT_MAPPING.put("OUT", ParameterMode.INOUT_LITERAL);
        TSQL_INOUT_MAPPING.put("OUTPUT", ParameterMode.INOUT_LITERAL);
        COLUMN_NAMES = new String[]{"", Messages.wizard_createSP_page2_parameter_label_name, Messages.wizard_createSP_page2_parameter_label_datatype, Messages.wizard_createSP_page2_parameter_label_inout, Messages.wizard_createSP_page2_parameter_label_default};
        COLUMN_LENGTH = new int[]{20, 200, 100, 60, 142};
    }

    public ParametersData() {
    }

    public ParametersData(EList params, DatabaseDefinition dbdef) {
        this.init(params, dbdef, true);
    }

    public void init(EList params, DatabaseDefinition dbdef) {
        this.init(params, dbdef, true);
    }

    public void init(EList params, DatabaseDefinition dbdef, boolean tsql) {
        this._tsql = tsql;
        this._rows.clear();
        boolean processed = false;
        for (SybaseParameter param : params) {
            int jdbcType = param.getJDBCParameterType().getValue();
            if (jdbcType == 5 || jdbcType == 3 || jdbcType == 0) continue;
            Routine routine = param.getRoutine();
            if (!processed) {
                if (routine instanceof SybaseRoutine) {
                    ((SybaseRoutine)routine).parseParameterDefaultValues();
                }
                processed = true;
            }
            Object[] data = new Object[this.getColumnCount()];
            data[0] = "";
            data[1] = param.getName();
            DataTypeProvider provider = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)new DatabaseVendorDefinitionId(dbdef.getProduct(), dbdef.getVersion())).getSQLDataService().getDataTypeProvider();
            String typeName = provider.getDataTypeString(param.getDataType(), false);
            if (param.getDataType() instanceof PredefinedDataType) {
                typeName = typeName.toLowerCase();
            }
            data[2] = typeName;
            data[3] = this.getParameterModeValue(param.getMode());
            String dft = param.getDefaultValue();
            if (dft == null) {
                dft = "";
            }
            data[4] = dft;
            ParametersRowData row = new ParametersRowData((ITableData)this, 0, data);
            row.setParameter(param);
            row.setValid(true);
            this._rows.add(row);
        }
    }

    public boolean isReadonly() {
        return false;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public int getColumnType(int col) {
        return 1;
    }

    public String getColumnHeader(int col) {
        return COLUMN_NAMES[col];
    }

    public Vector getRows() {
        return this._rows;
    }

    public boolean save() throws Exception {
        return false;
    }

    public void dispose() {
    }

    public IRowData insertRow() {
        Object[] data = new Object[this.getColumnCount()];
        ParametersRowData row = new ParametersRowData((ITableData)this, 3, data);
        this._rows.add(row);
        Object[] listeners = this._listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITableDataChangeListener)listeners[i]).rowAdded((IRowData)row);
            ++i;
        }
        return row;
    }

    public void insertRow(IRowData rowData, int row) {
        if (rowData instanceof ParametersRowData) {
            ((ParametersRowData)rowData).setParameter(null);
        }
        super.insertRow(rowData, row);
    }

    public ParameterMode getParameterMode(String modeValue) {
        if (this._tsql) {
            return (ParameterMode)TSQL_INOUT_MAPPING.get(modeValue);
        }
        return (ParameterMode)INOUT_MAPPING.get(modeValue);
    }

    public String getParameterModeValue(ParameterMode mode) {
        if (this._tsql && mode.getValue() == 2) {
            return "OUT";
        }
        HashMap mapping = this._tsql ? TSQL_INOUT_MAPPING : INOUT_MAPPING;
        for (String modeValue : mapping.keySet()) {
            ParameterMode mapMode = (ParameterMode)mapping.get(modeValue);
            if (!mapMode.equals(mode)) continue;
            return modeValue;
        }
        return mode.getLiteral();
    }
}

