/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.utils;

import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtil {
    public static void setEditorsProfileStatus(String profileName, int status) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return;
        }
        int i = 0;
        while (i < ht.length) {
            ISQLEditorInput sqlEditorInput;
            ISQLEditorConnectionInfo info;
            String editorProfile;
            IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (input instanceof ISQLEditorInput && (editorProfile = (info = (sqlEditorInput = (ISQLEditorInput)input).getConnectionInfo()).getConnectionProfileName()) != null && editorProfile.equals(profileName)) {
                info.setProfileStatus(status);
                info.setDatabase(null);
                if (status == 1) {
                    info.setConnectionProfileName(null);
                } else {
                    info.setConnectionProfileName(profileName);
                }
                SQLEditor editor = (SQLEditor)ref.getEditor(false);
                if (editor != null) {
                    editor.setConnectionInfo(info);
                }
            }
            ++i;
        }
    }

    public static boolean okToCloseEditors(String profileName) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return true;
        }
        int i = 0;
        while (i < ht.length) {
            ISQLEditorInput sqlEditorInput;
            ISQLEditorConnectionInfo info;
            final IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (input instanceof ISQLEditorInput && ((ISQLEditorInput)input).isConnectionRequired() && profileName.equals((info = (sqlEditorInput = (ISQLEditorInput)input).getConnectionInfo()).getConnectionProfileName())) {
                final boolean[] ok = new boolean[]{true};
                SQLEditorPlugin.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (ref.isDirty()) {
                            MessageDialog.openError(null, (String)Messages.Disconnect_error, (String)Messages.Cannot_disconnect_before_save);
                            ok[0] = false;
                        }
                    }
                });
                if (!ok[0]) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean closeAllEditors(String profileName) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return true;
        }
        boolean success = true;
        int i = 0;
        while (i < ht.length) {
            ITextEditor editor;
            ISQLEditorInput sqlEditorInput;
            ISQLEditorConnectionInfo info;
            IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (input instanceof ISQLEditorInput && ((ISQLEditorInput)input).isConnectionRequired() && profileName.equals((info = (sqlEditorInput = (ISQLEditorInput)input).getConnectionInfo()).getConnectionProfileName()) && (editor = (ITextEditor)ref.getEditor(false)) != null) {
                editor.close(true);
            }
            ++i;
        }
        return success;
    }

    public static void renameEditorsProfileName(String oldName, String newName) {
        IEditorReference[] ht = SQLEditorPlugin.getActiveWorkbenchPage().getEditorReferences();
        if (ht == null || ht.length == 0) {
            return;
        }
        int i = 0;
        while (i < ht.length) {
            SQLEditor editor;
            IEditorReference ref = ht[i];
            IEditorInput input = null;
            try {
                input = ref.getEditorInput();
            }
            catch (PartInitException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
            if (input instanceof ISQLEditorInput) {
                ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
                ISQLEditorConnectionInfo info = sqlEditorInput.getConnectionInfo();
                if (oldName.equals(info.getConnectionProfileName())) {
                    info.setConnectionProfileName(newName);
                    editor = (SQLEditor)ref.getEditor(false);
                    if (editor != null) {
                        editor.setConnectionInfo(info);
                    }
                }
            } else if (input.getAdapter(ProcIdentifier.class) instanceof ProcIdentifier) {
                ProcIdentifier prodId = (ProcIdentifier)input.getAdapter(ProcIdentifier.class);
                IEditorPart editorPart = ref.getEditor(false);
                if (oldName.equals(prodId.getProfileName())) {
                    ISQLEditorConnectionInfo info;
                    prodId.getDatabaseIdentifier().setProfileName(newName);
                    if (editorPart instanceof SQLEditor) {
                        editor = (SQLEditor)editorPart;
                        info = editor.getConnectionInfo();
                        info.setConnectionProfileName(newName);
                        if (editor != null) {
                            editor.setConnectionInfo(info);
                        }
                    } else if (editorPart.getAdapter(SQLEditor.class) instanceof SQLEditor) {
                        editor = (SQLEditor)((Object)editorPart.getAdapter(SQLEditor.class));
                        info = editor.getConnectionInfo();
                        info.setConnectionProfileName(newName);
                        if (editor != null) {
                            editor.setConnectionInfo(info);
                        }
                    }
                }
            }
            ++i;
        }
    }
}

