/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.ui.outline;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecoretools.diagram.ui.outline.AdditionalResources;
import org.eclipse.emf.ecoretools.diagram.ui.outline.NavigatorContentProvider;
import org.eclipse.emf.ecoretools.diagram.ui.outline.NavigatorLabelProvider;
import org.eclipse.emf.ecoretools.diagram.ui.outline.actions.DeleteDiagramAction;
import org.eclipse.emf.ecoretools.diagram.ui.outline.actions.DuplicateDiagramAction;
import org.eclipse.emf.ecoretools.diagram.ui.outline.actions.RenameDiagramAction;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Activator;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Messages;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.ModelElementComparer;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.OutlineDragAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.IPageSite;

public abstract class AbstractModelNavigator
extends Composite
implements IMenuListener {
    private IDiagramWorkbenchPart editor;
    private IDiagramGraphicalViewer diagramViewer;
    private TreeViewer viewer;
    private IPageSite site;
    private Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            AbstractModelNavigator.this.refreshViewer(true);
        }
    };

    public AbstractModelNavigator(Composite parent, IDiagramWorkbenchPart diagEditor, IPageSite pageSite) {
        super(parent, 2048);
        this.editor = diagEditor;
        this.diagramViewer = diagEditor.getDiagramGraphicalViewer();
        this.site = pageSite;
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.createContents(this);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected void createContents(Composite parent) {
        FilteredTree tree = new FilteredTree(parent, 2, new PatternFilter(), true);
        tree.setBackground(Display.getDefault().getSystemColor(1));
        tree.setLayoutData((Object)new GridData(1808));
        this.viewer = tree.getViewer();
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.initDragAndDrop();
        this.initProviders();
        this.initFilters();
        this.hookListeners();
        this.hookKeyListeners();
        this.viewer.setComparer((IElementComparer)new ModelElementComparer());
        this.viewer.setInput((Object)this.getModelResource());
        this.createContextMenu((StructuredViewer)this.viewer);
        this.refreshViewer();
    }

    protected Resource getDiagramResource() {
        Object model;
        if (this.diagramViewer != null && this.diagramViewer.getContents() != null && (model = this.diagramViewer.getContents().getModel()) instanceof Diagram) {
            return ((Diagram)model).eResource();
        }
        return null;
    }

    protected Resource getModelResource() {
        Object model = this.diagramViewer.getContents().getModel();
        if (model instanceof Diagram) {
            EObject eObject = ((Diagram)model).getElement();
            return EcoreUtil.getRootContainer((EObject)eObject).eResource();
        }
        return null;
    }

    protected void initDragAndDrop() {
        int ops = 3;
        OutlineDragAdapter dragAdapter = new OutlineDragAdapter((ISelectionProvider)this.viewer);
        this.viewer.addDragSupport(ops, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
    }

    protected void initProviders() {
        NavigatorAdapterFactoryContentProvider adapterContentProvider = new NavigatorAdapterFactoryContentProvider(this.getAdapterFactory());
        adapterContentProvider.inputChanged((Viewer)this.viewer, null, null);
        this.viewer.setContentProvider((IContentProvider)new NavigatorContentProvider(this.diagramViewer, (ITreeContentProvider)adapterContentProvider));
        DecoratingLabelProvider fullLabelProvider = new DecoratingLabelProvider((ILabelProvider)new NavigatorLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory())), Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.viewer.setLabelProvider((IBaseLabelProvider)fullLabelProvider);
    }

    protected void initFilters() {
    }

    protected void hookListeners() {
        if (this.getModelResource() != null && this.getModelResource().getResourceSet() != null) {
            this.getModelResource().getResourceSet().eAdapters().add((Object)this.modelListener);
        }
        if (this.getDiagramResource() != null) {
            this.getDiagramResource().eAdapters().add((Object)this.modelListener);
        }
    }

    protected void unhookListeners() {
        if (this.getDiagramResource() != null) {
            this.getDiagramResource().eAdapters().remove((Object)this.modelListener);
        }
        if (this.getModelResource() != null && this.getModelResource().getResourceSet() != null) {
            this.getModelResource().getResourceSet().eAdapters().remove((Object)this.modelListener);
        }
    }

    protected void hookKeyListeners() {
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                int cfr_ignored_0 = e.keyCode;
            }
        };
        this.viewer.getControl().addKeyListener(keyListener);
    }

    protected void createContextMenu(StructuredViewer sViewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.viewer.getControl());
        sViewer.getControl().setMenu(menu);
        this.site.registerContextMenu(((Object)((Object)this)).getClass().getName(), contextMenu, (ISelectionProvider)this.viewer);
    }

    private Resource getResourceFromSelection(Object selection) {
        Resource resource = null;
        if (selection instanceof EObject) {
            resource = ((EObject)selection).eResource();
        } else if (selection instanceof Resource) {
            resource = (Resource)selection;
        } else if (selection instanceof IWrapperItemProvider || selection instanceof FeatureMap.Entry) {
            resource = ((EObject)AdapterFactoryEditingDomain.unwrap((Object)selection)).eResource();
        }
        return resource;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("new"));
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("properties"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object currentSel = sel.getFirstElement();
        Resource resource = this.getResourceFromSelection(currentSel);
        if (currentSel instanceof AdditionalResources || resource != null) {
            if (sel.size() == 1) {
                Object selection = sel.getFirstElement();
                this.createSingleSelectionMenu(menuManager, selection);
            }
            this.createMultiSelectionMenu(menuManager, sel);
        }
    }

    protected void createMultiSelectionMenu(IMenuManager manager, IStructuredSelection selection) {
        IEditingDomainProvider domainProvider = (IEditingDomainProvider)this.editor.getAdapter(IEditingDomainProvider.class);
        if (domainProvider != null) {
            LoadResourceAction loadAction = new LoadResourceAction(domainProvider.getEditingDomain());
            manager.appendToGroup("additions-end", (IAction)loadAction);
        }
    }

    private void createSingleSelectionMenu(IMenuManager manager, Object selection) {
        EObject selectedObject = null;
        if (selection instanceof EObject) {
            selectedObject = (EObject)selection;
        } else if (selection instanceof IWrapperItemProvider || selection instanceof FeatureMap.Entry) {
            selectedObject = (EObject)AdapterFactoryEditingDomain.unwrap((Object)selection);
        }
        if (selectedObject != null) {
            if (this.isEMFMenuEnabledFor(selectedObject)) {
                this.createEMFMenu(manager, selectedObject);
            }
            if (this.isDiagramsMenuEnabledFor(selectedObject)) {
                this.createDiagramsMenu(manager, selectedObject);
            }
            if (this.isControlActionEnabledFor(selectedObject)) {
                this.createControlActions(manager);
            }
        }
    }

    protected boolean isEMFMenuEnabledFor(EObject selectedObject) {
        return true;
    }

    protected void createEMFMenu(IMenuManager manager, EObject selectedObject) {
        MenuManager menuManager;
        if (!this.isEMFMenuEnabledFor(selectedObject)) {
            return;
        }
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.getDiagramResource());
        StructuredSelection structuredSelection = new StructuredSelection((Object)selectedObject);
        Collection newChildDescriptors = editingDomain.getNewChildDescriptors((Object)selectedObject, null);
        Collection newSiblingDescriptors = editingDomain.getNewChildDescriptors(null, (Object)selectedObject);
        if (newChildDescriptors.size() > 0) {
            menuManager = new MenuManager(Messages.AbstractModelNavigator_NewChild);
            for (Object descriptor : newChildDescriptors) {
                menuManager.add((IAction)new CreateChildAction((IWorkbenchPart)this.getEditor(), (ISelection)structuredSelection, descriptor));
            }
            manager.add((IContributionItem)menuManager);
        }
        if (newSiblingDescriptors.size() > 0) {
            menuManager = new MenuManager(Messages.AbstractModelNavigator_NewSibling);
            for (Object descriptor : newSiblingDescriptors) {
                menuManager.add((IAction)new CreateSiblingAction((IWorkbenchPart)this.getEditor(), (ISelection)structuredSelection, descriptor));
            }
            manager.add((IContributionItem)menuManager);
        }
        manager.add((IContributionItem)new Separator());
        UndoAction undoAction = new UndoAction((EditingDomain)editingDomain);
        undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        manager.add((IContributionItem)new ActionContributionItem((IAction)undoAction));
        RedoAction redoAction = new RedoAction((EditingDomain)editingDomain);
        redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        manager.add((IContributionItem)new ActionContributionItem((IAction)redoAction));
        manager.add((IContributionItem)new Separator());
        CopyAction copyAction = new CopyAction((EditingDomain)editingDomain);
        copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        manager.add((IContributionItem)new ActionContributionItem((IAction)copyAction));
        CutAction cutAction = new CutAction((EditingDomain)editingDomain);
        cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        manager.add((IContributionItem)new ActionContributionItem((IAction)cutAction));
        PasteAction pasteAction = new PasteAction((EditingDomain)editingDomain);
        pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        manager.add((IContributionItem)new ActionContributionItem((IAction)pasteAction));
        manager.add((IContributionItem)new Separator());
        DeleteAction deleteAction = new DeleteAction((EditingDomain)editingDomain, true);
        deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        manager.add((IContributionItem)new ActionContributionItem((IAction)deleteAction));
        manager.add((IContributionItem)new Separator());
        ValidateAction validateAction = new ValidateAction();
        manager.add((IContributionItem)new ActionContributionItem((IAction)validateAction));
        ControlAction controlAction = new ControlAction((EditingDomain)editingDomain);
        manager.add((IContributionItem)new ActionContributionItem((IAction)controlAction));
        manager.add((IContributionItem)new Separator());
        copyAction.updateSelection((IStructuredSelection)structuredSelection);
        cutAction.updateSelection((IStructuredSelection)structuredSelection);
        pasteAction.updateSelection((IStructuredSelection)structuredSelection);
        deleteAction.updateSelection((IStructuredSelection)structuredSelection);
        validateAction.updateSelection((IStructuredSelection)structuredSelection);
        controlAction.updateSelection((IStructuredSelection)structuredSelection);
    }

    protected boolean isDiagramsMenuEnabledFor(EObject selectedObject) {
        return true;
    }

    protected void createDiagramsMenu(IMenuManager manager, EObject selectedObject) {
        if (selectedObject instanceof Diagram) {
            manager.appendToGroup("new", (IAction)new DuplicateDiagramAction((Diagram)selectedObject));
            manager.appendToGroup("new", (IAction)new RenameDiagramAction((Diagram)selectedObject));
            if (this.getEditor().getDiagram() != selectedObject) {
                manager.appendToGroup("new", (IAction)new DeleteDiagramAction((Diagram)selectedObject));
            }
        }
    }

    protected boolean isControlActionEnabledFor(EObject selectedObject) {
        return true;
    }

    private void createControlActions(IMenuManager manager) {
    }

    protected final void refreshViewer() {
        this.refreshViewer(false);
    }

    protected final void refreshViewer(boolean updateLabel) {
        if (this.viewer != null && !this.viewer.getTree().isDisposed() && this.diagramViewer.getContents() != null) {
            if (Display.getCurrent() != Display.getDefault()) {
                this.syncRefreshViewer(updateLabel);
            } else {
                this.viewer.refresh(updateLabel);
            }
        }
    }

    private void syncRefreshViewer(final boolean updateLabel) {
        this.viewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                AbstractModelNavigator.this.viewer.refresh(updateLabel);
            }
        });
    }

    public void dispose() {
        this.unhookListeners();
        super.dispose();
    }

    protected IDiagramWorkbenchPart getEditor() {
        return this.editor;
    }

    protected abstract AdapterFactory getAdapterFactory();

    protected class NavigatorAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public NavigatorAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public void notifyChanged(Notification notification) {
            if (notification instanceof IViewerNotification) {
                Object element = ((IViewerNotification)notification).getElement();
                if (!(element instanceof View)) {
                    super.notifyChanged(notification);
                } else if (element instanceof Diagram && ((IViewerNotification)notification).isLabelUpdate()) {
                    AbstractModelNavigator.this.refreshViewer(true);
                }
            } else {
                super.notifyChanged(notification);
            }
        }
    }
}

