/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.extension;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecoretools.filters.diagramfilters.IDiagramFilter;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.extension.FilteredDiagramTypeExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredDiagramTypeExtensionManager
implements IRegistryChangeListener {
    private static FilteredDiagramTypeExtensionManager instance;
    private static final String ATT_MODEL_ID = "modelId";
    private static final String ATT_DIAGRAM_FILTER = "diagramFilter";
    private Map<String, FilteredDiagramTypeExtension> filteredDiagramType;

    public static FilteredDiagramTypeExtensionManager getInstance() {
        if (instance == null) {
            instance = new FilteredDiagramTypeExtensionManager();
        }
        return instance;
    }

    private FilteredDiagramTypeExtensionManager() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        this.filteredDiagramType = new HashMap<String, FilteredDiagramTypeExtension>();
        this.initialize();
    }

    private void addFilteredDiagramTypeExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            String modelId;
            IConfigurationElement extElement = elements[j];
            if (this.checkRequiredTags(extElement) && !this.filteredDiagramType.containsKey(modelId = extElement.getAttribute(ATT_MODEL_ID))) {
                FilteredDiagramTypeExtension filteredDiagramTypeExtension = new FilteredDiagramTypeExtension(modelId);
                try {
                    if (extElement.getAttribute(ATT_DIAGRAM_FILTER) != null) {
                        IDiagramFilter diagramFilter = (IDiagramFilter)FilterPlugin.createExtension(extElement, ATT_DIAGRAM_FILTER);
                        filteredDiagramTypeExtension.setDiagramFilter(diagramFilter);
                    }
                    this.filteredDiagramType.put(modelId, filteredDiagramTypeExtension);
                }
                catch (CoreException ce) {
                    FilterPlugin.log(ce);
                }
            }
            ++j;
        }
    }

    private boolean checkRequiredTags(IConfigurationElement extendedClassLoaderElement) {
        String modelId = extendedClassLoaderElement.getAttribute(ATT_MODEL_ID);
        return !"".equals(modelId);
    }

    public Map<String, FilteredDiagramTypeExtension> getFilteredDiagramType() {
        this.initialize();
        return this.filteredDiagramType;
    }

    public FilteredDiagramTypeExtension getFilteredDiagramTypeExtension(String modelId) {
        FilteredDiagramTypeExtension filteredDiagramTypeExtension = this.filteredDiagramType.get(modelId);
        return filteredDiagramTypeExtension;
    }

    private void initialize() {
        if (this.filteredDiagramType.isEmpty()) {
            this.retrieveTypeProviders();
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
    }

    private void retrieveTypeProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.emf.ecoretools.filters", "filteredDiagramType");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addFilteredDiagramTypeExtension(extensions[i]);
            ++i;
        }
    }
}

