/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.view.template.model.VTControlValidationTemplate;
import org.eclipse.emf.ecp.view.template.model.VTTemplateFactory;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class SWTValidationHelper {
    public static final SWTValidationHelper INSTANCE = new SWTValidationHelper();
    private final String NO_CONTROLVALIDATIONCONFIG_WARNING = "Template has no control validation configuration.";
    private final Map<String, Color> colorMap = new LinkedHashMap<String, Color>();
    private VTViewTemplate defaultTemplate;

    private SWTValidationHelper() {
    }

    public Color getValidationBackgroundColor(int severity) {
        VTViewTemplate template = this.getTemplate();
        if (template.getControlValidationConfiguration() == null) {
            Activator.getDefault();
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.edit.swt", "Template has no control validation configuration."));
            return null;
        }
        String colorHex = null;
        switch (severity) {
            case 0: {
                colorHex = template.getControlValidationConfiguration().getOkColorHEX();
                break;
            }
            case 1: {
                colorHex = template.getControlValidationConfiguration().getInfoColorHEX();
                break;
            }
            case 2: {
                colorHex = template.getControlValidationConfiguration().getWarningColorHEX();
                break;
            }
            case 4: {
                colorHex = template.getControlValidationConfiguration().getErrorColorHEX();
                break;
            }
            case 8: {
                colorHex = template.getControlValidationConfiguration().getCancelColorHEX();
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (colorHex == null) {
            return null;
        }
        if (!this.colorMap.containsKey(colorHex)) {
            this.colorMap.put(colorHex, this.getColor(colorHex));
        }
        return this.colorMap.get(colorHex);
    }

    public Image getValidationIcon(int severity) {
        VTViewTemplate template = this.getTemplate();
        if (template.getControlValidationConfiguration() == null) {
            Activator.getDefault();
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.edit.swt", "Template has no control validation configuration."));
            return null;
        }
        String imageUrl = null;
        switch (severity) {
            case 0: {
                imageUrl = template.getControlValidationConfiguration().getOkImageURL();
                break;
            }
            case 1: {
                imageUrl = template.getControlValidationConfiguration().getInfoImageURL();
                break;
            }
            case 2: {
                imageUrl = template.getControlValidationConfiguration().getWarningImageURL();
                break;
            }
            case 4: {
                imageUrl = template.getControlValidationConfiguration().getErrorImageURL();
                break;
            }
            case 8: {
                imageUrl = template.getControlValidationConfiguration().getCancelImageURL();
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (imageUrl == null) {
            return null;
        }
        try {
            return Activator.getImage(new URL(imageUrl));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ImageDescriptor getValidationOverlayDescriptor(int severity) {
        VTViewTemplate template = this.getTemplate();
        if (template.getControlValidationConfiguration() == null) {
            Activator.getDefault();
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.ecp.edit.swt", "Template has no control validation configuration."));
            return null;
        }
        String imageUrl = null;
        switch (severity) {
            case 0: {
                imageUrl = template.getControlValidationConfiguration().getOkOverlayURL();
                break;
            }
            case 1: {
                imageUrl = template.getControlValidationConfiguration().getInfoOverlayURL();
                break;
            }
            case 2: {
                imageUrl = template.getControlValidationConfiguration().getWarningOverlayURL();
                break;
            }
            case 4: {
                imageUrl = template.getControlValidationConfiguration().getErrorOverlayURL();
                break;
            }
            case 8: {
                imageUrl = template.getControlValidationConfiguration().getCancelOverlayURL();
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (imageUrl == null) {
            return null;
        }
        try {
            return ImageDescriptor.createFromURL((URL)new URL(imageUrl));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private VTViewTemplate getTemplate() {
        VTViewTemplateProvider vtViewTemplateProvider = Activator.getDefault().getVTViewTemplateProvider();
        if (vtViewTemplateProvider == null || vtViewTemplateProvider.getViewTemplate() == null) {
            if (this.defaultTemplate == null) {
                this.defaultTemplate = VTTemplateFactory.eINSTANCE.createViewTemplate();
                VTControlValidationTemplate validationTemplate = VTTemplateFactory.eINSTANCE.createControlValidationTemplate();
                this.defaultTemplate.setControlValidationConfiguration(validationTemplate);
                validationTemplate.setOkColorHEX("ffffff");
                validationTemplate.setErrorColorHEX("ff0000");
                validationTemplate.setWarningColorHEX("FFD800");
                validationTemplate.setErrorImageURL(Activator.getDefault().getBundle().getResource("icons/validation_error.png").toExternalForm());
                validationTemplate.setErrorOverlayURL(Activator.getDefault().getBundle().getResource("icons/error_decorate.png").toExternalForm());
                validationTemplate.setWarningOverlayURL(Activator.getDefault().getBundle().getResource("icons/warning_decorate.png").toExternalForm());
                validationTemplate.setInfoOverlayURL(Activator.getDefault().getBundle().getResource("icons/info_decorate.gif").toExternalForm());
            }
            return this.defaultTemplate;
        }
        return vtViewTemplateProvider.getViewTemplate();
    }

    private Color getColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }
}

