/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelUtils;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="propagateFeature", label="Propagate Feature over References", description="In the metamodel, a feature is propagated opposite to a number of references. More specifically, the feature is created in each of the classes which are sources of the references. In the model, the values of that feature are moved accordingly.")
public class PropagateFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature to be propagated")
    public EStructuralFeature mainFeature;
    @EdaptParameter(description="The references opposite to which the feature is propagated")
    public List<EReference> references = new ArrayList<EReference>();

    @EdaptConstraint(restricts="references", description="Every reference has to target the class with the feature")
    public boolean checkReferencesType(EReference reference) {
        return reference.getEType() == this.mainFeature.getEContainingClass();
    }

    public void execute(Metamodel metamodel, Model model) {
        EStructuralFeature feature;
        boolean first = true;
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        for (EReference reference : this.references) {
            feature = null;
            if (first) {
                feature = this.mainFeature;
                first = false;
            } else {
                feature = (EStructuralFeature)MetamodelUtils.copy((EModelElement)this.mainFeature);
            }
            features.add(feature);
            reference.getEContainingClass().getEStructuralFeatures().add((Object)feature);
        }
        int i = 0;
        while (i < this.references.size()) {
            EReference reference = this.references.get(i);
            feature = (EStructuralFeature)features.get(i);
            for (Instance instance : model.getAllInstances(reference.getEContainingClass())) {
                Instance ref = (Instance)instance.get((EStructuralFeature)reference);
                if (ref == null) continue;
                Object value = ref.unset(this.mainFeature);
                instance.set(feature, value);
            }
            ++i;
        }
    }
}

