/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.net.URL;
import java.util.List;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.history.OperationInstance;
import org.eclipse.emf.edapt.history.instantiation.ui.TableItemPopupDialog;
import org.eclipse.emf.edapt.history.provider.HistoryEditPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class OperationViewer
extends TableViewer {
    private Image operationImage;

    public OperationViewer(Composite parent) {
        super(parent, 68354);
        this.init();
    }

    private void init() {
        URL url = (URL)HistoryEditPlugin.INSTANCE.getImage("full/obj16/OperationInstance");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.operationImage = imageDescriptor.createImage();
        final Table operationTable = this.getTable();
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List list = (List)inputElement;
                return list.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return OperationViewer.this.operationImage;
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                OperationInstance operationInstance = (OperationInstance)element;
                Operation operation = operationInstance.getOperation();
                switch (columnIndex) {
                    case 0: {
                        return operation.getLabel();
                    }
                    case 1: {
                        return operation.getDescription();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        operationTable.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (operationTable.getSelectionCount() > 0) {
                    TableItem tableItem = operationTable.getSelection()[0];
                    OperationViewer.this.showDescription(tableItem);
                }
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (operationTable.getSelectionCount() > 0) {
                    TableItem tableItem = operationTable.getSelection()[0];
                    OperationViewer.this.showDescription(tableItem);
                }
            }
        });
        this.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                OperationInstance oi1 = (OperationInstance)e1;
                OperationInstance oi2 = (OperationInstance)e2;
                return oi1.getOperation().getLabel().compareTo(oi2.getOperation().getLabel());
            }
        });
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                OperationInstance operationInstance = (OperationInstance)element;
                return !operationInstance.getOperation().isDeprecated();
            }
        });
    }

    private void showDescription(TableItem tableItem) {
        OperationInstance operationInstance = (OperationInstance)tableItem.getData();
        Operation operation = operationInstance.getOperation();
        TableItemPopupDialog dialog = new TableItemPopupDialog(tableItem, operation.getLabel(), operation.getDescription());
        dialog.open();
    }
}

