/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.history.util.HistorySwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EcoreReconstructorSwitchBase<E>
extends HistorySwitch<E> {
    protected void add(EObject element, EStructuralFeature feature, Object value) {
        if (feature.isMany()) {
            List list = (List)element.eGet(feature);
            list.add(value);
        } else {
            element.eSet(feature, value);
        }
    }

    protected void remove(EObject element, EStructuralFeature feature, Object value) {
        if (feature.isMany()) {
            ((List)element.eGet(feature)).remove(value);
        } else {
            element.eSet(feature, null);
        }
    }

    protected void set(EObject element, EStructuralFeature feature, Object value) {
        element.eSet(feature, value);
    }

    protected EObject create(EObject owner, EReference reference, EClass type) {
        EObject child = type.getEPackage().getEFactoryInstance().create(type);
        this.add(owner, (EStructuralFeature)reference, child);
        return child;
    }

    protected Collection delete(EObject element) {
        ResourceSet resourceSet = element.eResource().getResourceSet();
        UniqueEList elements = new UniqueEList();
        elements.add(element);
        TreeIterator i = element.eAllContents();
        while (i.hasNext()) {
            elements.add(i.next());
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll((Collection)elements, (ResourceSet)resourceSet);
        for (Map.Entry entry : usages.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                EStructuralFeature eStructuralFeature;
                EObject referencingEObject = setting.getEObject();
                if (elements.contains(referencingEObject) || !(eStructuralFeature = setting.getEStructuralFeature()).isChangeable() || !EcoreReconstructorSwitchBase.isModelElement(referencingEObject)) continue;
                this.remove(referencingEObject, eStructuralFeature, eObject);
            }
        }
        EReference feature = element.eContainmentFeature();
        EObject owner = element.eContainer();
        if (owner == null) {
            element.eResource().getContents().remove((Object)element);
        } else {
            this.remove(owner, (EStructuralFeature)feature, element);
        }
        return elements;
    }

    protected void move(EObject element, EObject target, EReference reference) {
        this.add(target, (EStructuralFeature)reference, element);
    }

    public static boolean isModelElement(EObject element) {
        EPackage p = element.eClass().getEPackage();
        boolean isModelElement = p == EcorePackage.eINSTANCE;
        return isModelElement;
    }
}

