/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.xml.ws.WebServiceRef;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.Black;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.SheepWS;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.SheepWSEndPoint;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ws.SheepWSService;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class WebServiceResourceTest
extends AbstractTest {
    @WebServiceRef(value=SheepWSService.class)
    public SheepWS sheepWS;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(WebServiceResourceTest.class)).build();
    }

    @Test(groups={"javaee-full", "jaxws"})
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="ee"), @SpecAssertion(section="fields_initializer_methods_ee", id="aq"), @SpecAssertion(section="fields_initializer_methods_ee", id="ar")})
    public void testInjectionIntoWebServiceEndpoint() throws Exception {
        Assert.assertTrue((boolean)this.sheepWS.isSheepInjected());
    }

    @Test(groups={"javaee-full", "jaxws"})
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="ff"), @SpecAssertion(section="resource_types", id="ae")})
    public void testResourceBeanTypes() {
        Bean<SheepWS> sheepWsBean = this.getUniqueBean(SheepWS.class, new Annotation[0]);
        Assert.assertEquals((int)sheepWsBean.getTypes().size(), (int)3);
        this.typeSetMatches(sheepWsBean.getTypes(), new Type[]{Object.class, SheepWS.class, SheepWSEndPoint.class});
        Bean<SheepWS> blackSheepWsBean = this.getUniqueBean(SheepWS.class, new Annotation[]{new AnnotationLiteral<Black>(){}});
        Assert.assertEquals((int)blackSheepWsBean.getTypes().size(), (int)2);
        this.typeSetMatches(blackSheepWsBean.getTypes(), new Type[]{Object.class, SheepWS.class});
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full", "jaxws"})
    @SpecAssertion(section="declaring_resource", id="ff")
    public void testResourceInvocation(@Black SheepWS sheepWS) {
        Assert.assertNotNull((Object)sheepWS);
        Assert.assertTrue((boolean)sheepWS.isSheepInjected());
    }
}

